import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import java.util.List;

// A observable class...
class Model extends Observable {
    private int valeur;
    public Model(int v) { valeur = v; }
    public int getValeur() { return valeur; }
    public void setValeur(int v) {
	valeur = v;
	setChanged();
	notifyObservers();
    }
}

// A concrete view asks for model's state and changes accordingly
class View1 extends JLabel implements Observer { 
    public void update(Observable source,Object datas) {
	Model m = (Model)source;
	setText("Value="+m.getValeur());
    }
}

// Controler acts on model
class Controler implements ActionListener {
    private Model m;
    public Controler(Model m) { this.m = m; }
    public void actionPerformed(ActionEvent e) {
	m.setValeur(m.getValeur()+1);
    }    
}

public class ActiveMVC implements Runnable {
    public void run() {
	final Model m = new Model(0);
	JFrame f = new JFrame("MVC");
	View1 v1 = new View1();
	View1 v2 = new View1();
	m.addObserver(v1);
	m.addObserver(v2);
	JButton b = new JButton("+1");
	Controler c = new Controler(m);
	b.addActionListener(c);

	f.getContentPane().setLayout(new FlowLayout());
	f.getContentPane().add(v1);
	f.getContentPane().add(v2);
	f.getContentPane().add(b);
	f.pack();
	f.setVisible(true);

	new Thread() {
	    public void run() {
		while (true) {
		    try {
			Thread.sleep(1000);
			m.setValeur(m.getValeur()+1);
		    } catch(InterruptedException e) {
			e.printStackTrace();
			System.exit(1);
		    }
		}
	    }
	}.start();
    }
    public static void main(String []args) {
	SwingUtilities.invokeLater(new ActiveMVC());
    }
}
