import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.awt.geom.*;
import java.awt.font.*;

public class AlphaExemple extends JPanel {
  private Dimension d;
  private boolean onOff;
  public AlphaExemple() {
    d = new Dimension(400,400);
    onOff = false;
    setBackground(Color.LIGHT_GRAY);
  }
  public void switchOn() { onOff = !onOff; repaint(); }
  public Dimension getPreferredSize() { return d; }
  public void paintComponent(Graphics g) {
    Graphics2D g2 = (Graphics2D)g.create();
    g2.setBackground(getBackground());
    g2.clearRect(0,0,getSize().width,getSize().height);
    g2.setColor(Color.BLACK);
    g2.fillRect(getSize().width/4,getSize().height/4,getSize().width/2,getSize().height/2);

    if (onOff) {
      g2 = (Graphics2D)g;
      g2.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER,0.5f));
      g2.setColor(Color.RED);
      g2.fillRect(0,0,getSize().width,getSize().height/2);
      g2.setColor(Color.GREEN);
      g2.fillRect(0,getSize().height/2,getSize().width,getSize().height/2);
    }
  }
  public static void main(String []a) {
    SwingUtilities.invokeLater(new Runnable() {
        public void run() {
          JFrame fenetre = new JFrame("Alpha Exemple");
          fenetre.getContentPane().setLayout(new BorderLayout());
          JButton b = new JButton("Go");
          final AlphaExemple a = new AlphaExemple();
          b.addActionListener(new ActionListener() {
              public void actionPerformed(ActionEvent e) {
                a.switchOn();
              }
            });
          fenetre.getContentPane().add(b,BorderLayout.NORTH);
          fenetre.getContentPane().add(a,BorderLayout.CENTER);
          fenetre.pack();
          fenetre.setVisible(true);
        }
      });
  }
}
