import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import javax.swing.text.*;
import java.util.*;
import java.awt.image.*;
import java.net.*;
import javax.imageio.*;

class MyPanel extends JPanel {
    private BufferedImage image1, image2;
    LookupOp op;
    short [] b0;
    short [] b1;
    short [] b2;
    short [] b3;
    public MyPanel() {
	try {
	    setPreferredSize(new Dimension(200,200));
	    image1 = ImageIO.read(new File("i2.jpeg"));
	    image2 = new BufferedImage(image1.getWidth(),image1.getHeight(),BufferedImage.TYPE_INT_ARGB);
	    image2.getGraphics().drawImage(image1,0,0,null);
	    image1 = ImageIO.read(new File("i1.jpeg"));
	    b0 = new short[256];
	    b1 = new short[256];
	    b2 = new short[256];
	    b3 = new short[256];
	    short [][]bs = new short[4][];
	    bs[0] = b0;
	    bs[1] = b1;
	    bs[2] = b2;
	    bs[3] = b3;
	    for (int i=0; i<256; i++) b0[i] = (short)(i);
	    for (int i=0; i<256; i++) b1[i] = (short)(i);
	    for (int i=0; i<256; i++) b2[i] = (short)(i);
	    for (int i=0; i<256; i++) b3[i] = (short)(255);
	    ShortLookupTable tab = new ShortLookupTable(0,bs);
	    op = new LookupOp(tab,null);
	    setPreferredSize(new Dimension(image2.getWidth(),
					   2*image2.getHeight()));
	} catch(Exception e) {
	    e.printStackTrace();
	}
    }
    public void paintComponent(Graphics g) {
	Graphics2D g2 = (Graphics2D)g;
	g2.setColor(Color.WHITE);
	g2.fillRect(0,0,image2.getWidth(),2*image2.getHeight());
	g2.drawImage(image1,0,0,null);
	g2.drawImage(image2,op,0,0);
	g2.drawImage(image2,op,0,image2.getHeight());
    }
    public void setValue(int v) {
	for (int i=0; i<256; i++) b3[i] = (short)(v);
	repaint();
    }
}

public class AnimatedImageExample implements Runnable {
    public static void main(String [] args) {
	SwingUtilities.invokeLater(new AnimatedImageExample());
    }
    public void run() {
	JFrame f = new JFrame(this.getClass().getName());
	Container c = f.getContentPane();
	c.setLayout(new BorderLayout());
	final MyPanel p = new MyPanel();
	c.add(p,BorderLayout.CENTER);
	JSlider s = new JSlider(SwingConstants.HORIZONTAL,0,255,255);
	s.setMajorTickSpacing(20);
	s.setPaintTicks(true);
	s.setLabelTable(s.createStandardLabels(50));
	s.setPaintLabels(true);
	c.add(s,BorderLayout.SOUTH);
	s.addChangeListener(new ChangeListener() {
		public void stateChanged(ChangeEvent e) {
		    p.setValue(((JSlider)(e.getSource())).getValue());
		}
	    });
	f.pack();
	f.setVisible(true);
    }
}