import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

class Auditeur implements ActionListener {
    private JFrame theFrame;
    public Auditeur(JFrame f) { theFrame = f; }
    public void actionPerformed(ActionEvent e) {
	final JDialog dialog = new JDialog(theFrame);
	if (theFrame!=null) {
	    dialog.setTitle("Attached to "+theFrame.getTitle());
	    dialog.setLocationRelativeTo(theFrame);
	}
	Dialog.ModalityType type = Dialog.ModalityType.APPLICATION_MODAL;
	dialog.setModalityType(type);
	if (dialog.getModalityType()!=type) {
	    System.out.println("Modality not supported");
	}
	JButton b = new JButton("Bye");
	b.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    dialog.setVisible(false);
		}
	    });
	dialog.getContentPane().add(b);
	dialog.pack();
	dialog.setVisible(true);
    }
}

public class AppModalExample implements Runnable {
    public void run() {
	JFrame fenetre1 = new JFrame("Fenetre1");
	JLabel l1 = new JLabel("Une superbe et magnifique fenêtre");
	JButton b1 = new JButton("Vas-y tapes-moi!");
	l1.setPreferredSize(new Dimension(400,400));
	fenetre1.getContentPane().setLayout(new BorderLayout());
	fenetre1.getContentPane().add(l1,BorderLayout.CENTER);
	fenetre1.getContentPane().add(b1,BorderLayout.SOUTH);
	b1.addActionListener(new Auditeur(fenetre1));

	JFrame fenetre2 = new JFrame("Fenetre2");
	JLabel l2 = new JLabel("Une autre magnifique fenêtre");
	JButton b2 = new JButton("Vas-y tapes-moi!");
	l2.setPreferredSize(new Dimension(400,400));
	fenetre2.getContentPane().setLayout(new BorderLayout());
	fenetre2.getContentPane().add(l2,BorderLayout.CENTER);
	fenetre2.getContentPane().add(b2,BorderLayout.SOUTH);
	b2.addActionListener(new Auditeur(fenetre2));

	fenetre1.pack();
	fenetre2.pack();
	fenetre1.setVisible(true);
	fenetre2.setVisible(true);
    }
    public static void main(String []args) {
	SwingUtilities.invokeLater(new AppModalExample());
    }
}