import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.print.*;
import java.awt.geom.*;
import java.awt.image.*;
import javax.print.*;
import javax.print.attribute.*;
import javax.swing.colorchooser.*;
import javax.imageio.*;
import java.io.*;

class OpenSaveListener implements ActionListener {
  private SpecialPanel p;
  private static JFileChooser c = new JFileChooser();
  public OpenSaveListener(SpecialPanel p) {
    this.p = p;
  }
  public void actionPerformed(ActionEvent e) {
    System.out.println(e);
    String command = ((JMenuItem)(e.getSource())).getActionCommand();
    int resultat = switch(command) {
    case "open" -> c.showOpenDialog(null);
    case "save" -> c.showSaveDialog(null);
    default -> -1;
    };
    if (resultat == JFileChooser.APPROVE_OPTION) {
      File f = c.getSelectedFile();
      System.out.println(f);
      switch(command) {
      case "open":
        try {
          p.setImage(ImageIO.read(f));
        } catch(Exception ex) {
          System.err.println("Something's wrong reading");
        }
      case "save":
        try {
          ImageIO.write(p.getImage(),"png",f);
        } catch(Exception ex) {
          System.err.println("Something's wrong writing");
        }
      }
    }
  }
}

class SpecialPanel extends JPanel implements MouseListener,
                                             MouseMotionListener,
                                             Printable,
                                             ChangeListener,
                                             ComponentListener {
  private int x, y, ox, oy;
  private Dimension dim;
  private BufferedImage bi;
  private Graphics gi;
  private AffineTransform scaling;
  private JFrame f;
  public SpecialPanel(JFrame f) {
    super();
    setBackground(Color.WHITE);
    dim = new Dimension(500,500);
    addMouseListener(this);
    scaling = new AffineTransform();
    scaling.scale(72.0f/300.0f,72.0f/300.0f); // 300 DPI scaling
    this.f = f;
    this.addComponentListener(this);
  }
  public void mousePressed(MouseEvent m) {
    ox = m.getX();
    oy = m.getY();
    addMouseMotionListener(this);
  }
  public void mouseReleased(MouseEvent m) {
    removeMouseMotionListener(this);
  }
  public void mouseEntered(MouseEvent m) { }
  public void mouseExited(MouseEvent m) { }
  public void mouseClicked(MouseEvent m) { }
  public Dimension getPreferredSize() { return dim; }
  
  public int print(Graphics g,PageFormat f,int index) throws PrinterException {
    if (index>0) return Printable.NO_SUCH_PAGE; // So, where is jimmy?
    ((Graphics2D)g).translate(f.getImageableX(), f.getImageableY()); // offset jump
    ((Graphics2D)g).drawImage(bi,scaling,null); // do the trick at 300 DPI
    return Printable.PAGE_EXISTS;
  }
  public void paintComponent(Graphics g) {
    if (bi==null) { // create on off-screen if needed
      bi = ((Graphics2D)g).getDeviceConfiguration().createCompatibleImage((int)dim.getWidth(),(int)dim.getHeight());
      gi = bi.getGraphics();
      gi.setColor(getBackground());
      gi.fillRect(0,0,(int)dim.getWidth(),(int)dim.getHeight());
      gi.setColor(Color.BLACK);
    }
    g.drawImage(bi,0,0,null); // do the trick at 72 DPI
  }
  
  public void mouseDragged(MouseEvent e) {
    x = e.getX(); // get a pos
    y = e.getY();
    gi.setColor(getForeground());
    gi.drawLine(ox,oy,x,y); // draw it on off-screen image
    ox = x; // remember the pos
    oy = y;
    repaint(); // do the trick on screen
  }
  public void mouseMoved(MouseEvent e) { }
  public void stateChanged(ChangeEvent e) {
    setForeground(((ColorSelectionModel)(e.getSource())).getSelectedColor());
  }
  public BufferedImage getImage() {
    return this.bi;
  }
  public void setImage(BufferedImage b) {
    this.bi = b;
    this.gi = (Graphics2D)(b.getGraphics());
    this.invalidate();
    dim = new Dimension(b.getWidth(),b.getHeight());
    this.getParent().invalidate();
    this.getParent().validate();
    this.repaint();
    f.pack();
  }
  public void componentHidden(ComponentEvent e) {}
  public void componentMoved(ComponentEvent e) {}
  public void componentResized(ComponentEvent e) {
    if (bi!=null) {
      System.out.println(this.getWidth()+" "+this.getHeight());
      Image b = bi.getScaledInstance(this.getWidth(),this.getHeight(),Image.SCALE_SMOOTH);

      BufferedImage newImage = new BufferedImage(getWidth(), getHeight(), BufferedImage.TYPE_INT_ARGB);
      Graphics g = newImage.getGraphics();
      g.drawImage(b, 0, 0, null);
      setImage(newImage);
    }
  }
  public void componentShown(ComponentEvent e) {}
}

public class ColorChooserExample2 implements Runnable {
    public void run() {
	JFrame f = new JFrame("Drawing & ColorChooser");
	final SpecialPanel l = new SpecialPanel(f);
	f.getContentPane().add(l);
	JMenu m = new JMenu("Fichier");
        JMenuItem open = new JMenuItem("Ouvrir...");
        JMenuItem save = new JMenuItem("Sauver...");
	JMenuItem mi1 = new JMenuItem("Imprimer");
	JMenuItem mi2 = new JMenuItem("Quitter");
        m.add(open);
        m.add(save);
        m.add(new JSeparator());
	m.add(mi1);
        m.add(new JSeparator());
	m.add(mi2);
	JMenuBar mb = new JMenuBar();
	mb.add(m);
	f.setJMenuBar(mb);
	f.pack();
	f.setVisible(true);
	JColorChooser cc = new JColorChooser(l.getForeground());
	JDialog d = new JDialog(f);
	d.getContentPane().add(cc);
	d.pack();
	d.setVisible(true);
	cc.getSelectionModel().addChangeListener(l);

	mi1.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    PrinterJob pj = PrinterJob.getPrinterJob();
		    pj.setJobName("Un magnifique dessin");
		    pj.setPrintable(l);
		    if (pj.printDialog()) { // ask user
			try {
			    pj.print(); // do the trick
			} catch(PrinterException ex) {
			    ex.printStackTrace();
			}
                    }
		}
	    });
	mi2.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    System.exit(0);
		}
	    });
        open.setActionCommand("open");
        ActionListener al = new OpenSaveListener(l);
        open.addActionListener(al);
        save.setActionCommand("save");
        save.addActionListener(al);
    }
    public static void main(String []args) {
      SwingUtilities.invokeLater(new ColorChooserExample2());
      for (var x : ImageIO.getWriterFormatNames()) {
	System.out.println(x);
	}
      for (var x : ImageIO.getWriterFileSuffixes()) {
	System.out.println("."+x);
	}
      for (var x : ImageIO.getWriterMIMETypes()) {
	System.out.println("mime "+x);
	}
    }
}
