import java.awt.*;
import java.awt.event.*;
import java.awt.font.*;
import java.awt.geom.*;
import java.awt.image.*;
import javax.swing.*;
import javax.swing.event.*;
 
public class ComposeExample extends JPanel implements ItemListener,ChangeListener {
  CompPanel comp;
  JLabel alphaLabel, rulesLabel;
  JSlider alphaSlider;
  JComboBox<String> rules;
  int rule = 0;
  float alpha = 1.0f;
 
  public ComposeExample() {
    GridBagLayout layout = new GridBagLayout();
    setLayout(layout);
 
    GridBagConstraints l = new GridBagConstraints();
    l.gridx = 0;
    l.gridy = 0;
    l.gridheight = 1;
    l.gridwidth = 1;
    l.weightx = 5.0;
    l.fill = GridBagConstraints.BOTH;
    alphaLabel = new JLabel();
    alphaLabel.setText("Alpha");
    alphaLabel.setHorizontalAlignment(JLabel.CENTER);
    layout.setConstraints(alphaLabel, l);
    add(alphaLabel);
 
    l.gridx = 1;
    l.gridy = 0;
    l.gridwidth = 1;
    l.gridwidth = 1;
    l.weightx = 0;
    rulesLabel = new JLabel();
    rulesLabel.setText("Rules");
    rulesLabel.setHorizontalAlignment(JLabel.CENTER);
    layout.setConstraints(rulesLabel, l);
    add(rulesLabel);   
 
    GridBagConstraints a = new GridBagConstraints();
    a.gridx = 0;
    a.gridy = 1;
    a.gridheight = 1;
    a.gridwidth = 1;
    a.weightx = 5.0;
    a.fill = GridBagConstraints.BOTH;
    alphaSlider = new JSlider(0,100,100);
    alphaSlider.setMajorTickSpacing(10);
    alphaSlider.setMinorTickSpacing(1);
    alphaSlider.setPaintTicks(true);
    alphaSlider.addChangeListener(this);
    layout.setConstraints(alphaSlider, a);
    add(alphaSlider);
 
    a.gridx = 1;
    a.gridy = 1;
    a.weightx = 0;
    a.gridheight = 1;
    a.gridwidth = 1;
    rules = new JComboBox<String>();
    layout.setConstraints(rules, a);
    rules.addItem("SRC");
    rules.addItem("DST_IN");
    rules.addItem("DST_OUT");
    rules.addItem("DST_OVER");
    rules.addItem("SRC_IN");
    rules.addItem("SRC_OVER");
    rules.addItem("SRC_OUT");
    rules.addItem("CLEAR");
    rules.addItemListener(this);
    add(rules);
 
    GridBagConstraints fC = new GridBagConstraints(); 
    fC.gridx = 0;
    fC.gridy = 2;
    fC.gridheight = 1;
    fC.gridwidth = 2;
    fC.fill = GridBagConstraints.BOTH;
    fC.weightx = 6.0;
    fC.weighty = 1.0;
    comp = new CompPanel();
    layout.setConstraints(comp, fC);
    add(comp); 
  }

  public void stateChanged(ChangeEvent e) {
    JSlider slider = (JSlider)e.getSource();
    alpha = slider.getValue()/100.0f;
    comp.changeRule(alpha, rule);
  }
 
  public void itemStateChanged(ItemEvent e){
    if ( e.getStateChange() != ItemEvent.SELECTED ) return;
    rule = rules.getSelectedIndex();
    comp.changeRule(alpha, rule);
  }
 
  public static void main(String s[]) {
    SwingUtilities.invokeLater(new Runnable() {
        public void run() {
          JFrame f = new JFrame("ComposeExample");
          f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
          ComposeExample panneau = new ComposeExample();
          f.getContentPane().add(panneau);
          f.pack();
          f.setSize(new Dimension(300,300));
          f.setVisible(true);
        }
      });
  }
}
 
class CompPanel extends JPanel {
 
  AlphaComposite ac = AlphaComposite.getInstance(AlphaComposite.SRC);  
  float alpha = 1.0f;

  private final static int [] rules = {
    AlphaComposite.SRC, AlphaComposite.DST_IN, AlphaComposite.DST_OUT,
    AlphaComposite.DST_OVER, AlphaComposite.SRC_IN, AlphaComposite.SRC_OVER,
    AlphaComposite.SRC_OUT, AlphaComposite.CLEAR
  };
 
  public void changeRule(float alpha, int rule) {
    ac = AlphaComposite.getInstance(rules[rule], alpha);
    repaint();
  }
 
  public void paintComponent(Graphics g) {
    Graphics2D g2 = (Graphics2D) g;
 
    Dimension d = getSize();
    int w = d.width;
    int h = d.height; 
 
    BufferedImage buffImg = new BufferedImage(w, h, BufferedImage.TYPE_INT_ARGB);
    Graphics2D gbi = buffImg.createGraphics();

    g2.setColor(Color.white);
    g2.fillRect(0, 0, d.width, d.height);
 
    int rectx = w/4;
    int recty = h/4;
 
    gbi.setColor(new Color(0.0f, 0.0f, 1.0f, 1.0f));
    gbi.fill(new Rectangle2D.Double(rectx, recty, 150, 100));
    gbi.setColor(new Color(1.0f, 0.0f, 0.0f, 1.0f));    
    gbi.setComposite(ac);
    gbi.fill(new Ellipse2D.Double(rectx+rectx/2,recty+recty/2,150,100));
 
    g2.drawImage(buffImg, null, 0, 0);
  }
}   
