import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

class Auditeur implements ActionListener {
    private JFrame theFrame;
    public Auditeur(JFrame f) { theFrame = f; }
    public void actionPerformed(ActionEvent e) {
	int resultat = JOptionPane.showConfirmDialog(theFrame,
			      "Avec vos yeux cernés, "+
			      "vous me semblez bien fatigué.\n"+
			      "Désirez-vous vous reposer ?",
			      "Prenez une décision une fois dans votre vie!",
			      JOptionPane.YES_NO_CANCEL_OPTION,
                              JOptionPane.PLAIN_MESSAGE);
	if (resultat==JOptionPane.YES_OPTION) {
	    System.out.println("Feignasse!");
        }
        String s = switch(resultat) {
        case JOptionPane.YES_OPTION -> "YES";
        case JOptionPane.NO_OPTION -> "NO";
        case JOptionPane.CANCEL_OPTION -> "CANCEL";
        case JOptionPane.CLOSED_OPTION -> "CLOSED";
        default -> "???";
        };
        System.out.println("Resultat: "+s);
    }
}

public class ConfirmDialogExample implements Runnable {
    public void run() {
	JFrame fenetre = new JFrame("Fenetre1");
	JLabel l = new JLabel("Une superbe et magnifique fenêtre");
	JButton b = new JButton("Vas-y tapes-moi!");
	l.setPreferredSize(new Dimension(400,400));
	fenetre.getContentPane().setLayout(new BorderLayout());
	fenetre.getContentPane().add(l,BorderLayout.CENTER);
	fenetre.getContentPane().add(b,BorderLayout.SOUTH);
	b.addActionListener(new Auditeur(fenetre));

	fenetre.pack();
	fenetre.setVisible(true);
    }
    public static void main(String []args) {
	SwingUtilities.invokeLater(new ConfirmDialogExample());
    }
}
