import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

class MonComposant extends JPanel {
    public MonComposant() {
	setBackground(Color.RED);
        setPreferredSize(new Dimension(2000,2000));
    }
    public void paintComponent(Graphics g) {
      System.out.println("PAINT "+g.hashCode());
	super.paintComponent(g); // do the default, at least bg filled
	Color c = Color.RED;
	Dimension d = getSize();
	int l = d.width/20-2;
	int h = d.height/20-2;
	for (int i=0; i<10; i++) {
	    g.setColor(c);
	    g.fillRect(0+l*i,0+i*h,d.width-i*2*l,d.height-i*2*h);
	    c = c.darker();
	}
    }
}

public class CustomJPanelExample implements Runnable {
    public void run() {
	JFrame f = new JFrame("MonComposant");
	JLabel l1 = new JLabel("Ici");
        l1.setBackground(Color.BLUE);
        l1.setOpaque(true);

	JLabel l2 = new JLabel("Là");
	MonComposant m = new MonComposant();
	Container c = f.getContentPane();
	c.setLayout(new BorderLayout());
	c.add(l1,BorderLayout.NORTH);
	c.add(m,BorderLayout.CENTER);
	c.add(l2,BorderLayout.SOUTH);
        JButton b = new JButton("Bonjour");
        m.add(b);

	f.pack();
	f.setVisible(true);
    }
    public static void main(String []args) {
	SwingUtilities.invokeLater(new CustomJPanelExample());
    }
}
