import java.awt.*;
import javax.swing.*;
import java.awt.geom.*;
import java.awt.font.*;

public class CustomStrokeExemple extends JPanel {
  private class CustomStroke implements Stroke {
    private void fuzz(float []f,int l) {
      for (int i=0; i<l; i++) {
        f[i] += (float)((Math.random()-0.5) * 10.0);
      }
    }
    public Shape createStrokedShape(Shape p) {
      GeneralPath s = new GeneralPath();
      float[] c = new float[6];
      for (PathIterator i = p.getPathIterator(null); !i.isDone(); i.next()) {
        int type = i.currentSegment(c);
        switch (type) {
        case PathIterator.SEG_MOVETO:
          fuzz(c, 2);
          s.moveTo(c[0], c[1]);
          break;
        case PathIterator.SEG_LINETO:
          fuzz(c, 2);
          s.lineTo(c[0], c[1]);
          break;
        case PathIterator.SEG_QUADTO:
          fuzz(c, 4);
          s.quadTo(c[0], c[1], c[2], c[3]);
          break;
        case PathIterator.SEG_CUBICTO:
          fuzz(c, 6);
          s.curveTo(c[0], c[1], c[2], c[3], c[4], c[5]);
          break;
        case PathIterator.SEG_CLOSE:
          s.closePath();
          break;
        }
      }
      Stroke stroke = new BasicStroke((int)(Math.random()*5)+2);
      return stroke.createStrokedShape(s);
    }
  }
  private GeneralPath dessin;
  private Dimension d;
  private Stroke stroke;
  public CustomStrokeExemple() {
    Font f = new Font("Serif", Font.BOLD, 100);
    FontRenderContext frc = new FontRenderContext(null, false, false);
    dessin = new GeneralPath();

    TextLayout tl = new TextLayout("JBY",f,frc);
    Shape s = tl.getOutline(null);
    dessin.append(s.getPathIterator(null),false);
    int l = tl.getPixelBounds(frc,0,0).width;
    int h = tl.getPixelBounds(frc,0,0).height;
    dessin.moveTo(0,20);
    dessin.lineTo(l,20);
    dessin.lineTo(l,30);
    dessin.lineTo(0,30);
    dessin.lineTo(0,20);
    dessin.closePath();
    d = new Dimension(2*l+150,h+100);
    stroke = new CustomStroke();
  }
  public Dimension getPreferredSize() {
    return d;
  }
  public void paintComponent(Graphics g) {
    Graphics2D g2 = (Graphics2D)g;
    g2.translate(50,getSize().getHeight()-50);
    g2.draw(dessin);

    g2.setStroke(stroke);
    g2.translate(getSize().getWidth()/2,0);
    g2.draw(dessin);
  }
  public static void main(String []a) {
    SwingUtilities.invokeLater(new Runnable() {
        public void run() {
          JFrame fenetre = new JFrame("Custom Stroke Exemple");
          fenetre.setContentPane(new CustomStrokeExemple());
          fenetre.pack();
          fenetre.setVisible(true);
        }
      });
  }
}
