import java.awt.*;
import java.awt.dnd.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.text.*;
import java.awt.datatransfer.*;
import java.io.*;

/* The TransferHandler in action */
class ColorTransferHandler extends TransferHandler {
    private DataFlavor cdf;
    private JPanel dropPanel;

    public ColorTransferHandler(JPanel p) {
	cdf = new DataFlavor(DataFlavor.javaJVMLocalObjectMimeType+
			     ";class="+Color.class.getName(),"Couleur java");
	dropPanel = p;
    }
    public boolean canImport(TransferHandler.TransferSupport ts) {
	DataFlavor [] dfs = ts.getDataFlavors();
	for (DataFlavor df : dfs) {
	    System.out.println("canImport "+df);
	}
	if (!ts.isDrop()) return false;
	return ts.isDataFlavorSupported(cdf);
    }
    public boolean importData(TransferHandler.TransferSupport ts) {
      //	if (!canImport(ts)) return false;
	System.out.println("importData");
	Transferable t = ts.getTransferable();
	try {
	    Color c = (Color)t.getTransferData(cdf);
	    dropPanel.setBackground(c);
	    return true;
	} catch(UnsupportedFlavorException ue) {
	    ue.printStackTrace();
	    return false;
	} catch(IOException ie) {
	    ie.printStackTrace();
	    return false;
	}
    }
}

/* The TransferHandler at the source */
class ColorTransferHandlerSource extends TransferHandler {
    private DataFlavor cdf;
    private MonComposant mc;
    public ColorTransferHandlerSource(MonComposant mc) {
	cdf = new DataFlavor(DataFlavor.javaJVMLocalObjectMimeType+
			     ";class="+Color.class.getName(),"Couleur java");
	this.mc = mc;
    }
    public int getSourceActions(JComponent c) {
	System.out.println("getSourceActions");
	return TransferHandler.COPY;
    }
    protected Transferable createTransferable(JComponent c) {
	System.out.println("createTransferable");
	return new ColorTransfer(c.getBackground());
    }
    protected void exportDone(JComponent c,Transferable t,int a) {
	System.out.println("done");
    }
}

/* Objet being transfered */
class ColorTransfer implements Transferable {
    private Color c;
    private DataFlavor []dfs;
    public ColorTransfer(Color c) {
	dfs = new DataFlavor[1];
	dfs[0] = new DataFlavor(DataFlavor.javaJVMLocalObjectMimeType+
				";class="+Color.class.getName(),"Couleur java");
	this.c = c;
    }
    public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException,IOException {
      System.out.println("getTransferData");
	if (!df.equals(dfs[0])) throw new UnsupportedFlavorException(df);
	return c;
    }
    public DataFlavor [] getTransferDataFlavors() {
	return dfs;
    }
    public boolean isDataFlavorSupported(DataFlavor df) {
      System.out.println("isDataFlavorSupported");
	return df.equals(dfs[0]);
    }
}

class MonComposant extends JPanel implements MouseListener {
    public MonComposant() {
	setBackground(Color.RED);
	setPreferredSize(new Dimension(400,400));
	setTransferHandler(new ColorTransferHandlerSource(this));
	this.addMouseListener(this);
    }
    public void mousePressed(MouseEvent e) {
	JPanel p = (JPanel)e.getSource();
	p.getTransferHandler().exportAsDrag(p,e,TransferHandler.COPY);
	e.consume();
    }
    public void mouseReleased(MouseEvent e) { }
    public void mouseClicked(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) { }
}

public class DND2Example implements Runnable {
    public void run() {
	JPanel p = new JPanel();
	p.setBackground(Color.BLUE);
	p.setPreferredSize(new Dimension(400,400));
	p.setTransferHandler(new ColorTransferHandler(p));

	MonComposant mc = new MonComposant();

	JFrame f = new JFrame("DND");
	f.getContentPane().setLayout(new FlowLayout());
	f.getContentPane().add(p);
	f.getContentPane().add(mc);

	f.pack();
	f.setVisible(true);
    }
    public static void main(String [] args) {
	SwingUtilities.invokeLater(new DND2Example());
    }
}
