import java.awt.*;
import java.awt.dnd.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.text.*;
import java.awt.datatransfer.*;
import java.io.*;
import javax.swing.border.*;
import java.awt.image.*;
import java.util.*;

class ColorTransfer implements Transferable {
    private Color c;
    private DataFlavor []dfs;
    public ColorTransfer(Color c) {
	dfs = new DataFlavor[1];
	dfs[0] = new DataFlavor(DataFlavor.javaJVMLocalObjectMimeType+
				";class="+Color.class.getName(),"Couleur java");
	this.c = c;
    }
    public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException,IOException {
	if (!df.equals(dfs[0])) throw new UnsupportedFlavorException(df);
	return c;
    }
    public DataFlavor [] getTransferDataFlavors() {
	return dfs;
    }
    public boolean isDataFlavorSupported(DataFlavor df) {
	return df.equals(dfs[0]);
    }
}

class ColorTransferHandler extends TransferHandler {
    public int getSourceActions(JComponent c) {
	return TransferHandler.COPY;
    }
    protected Transferable createTransferable(JComponent c) {
	return new ColorTransfer(c.getBackground());
    }
}

class ColorDropTarget implements DropTargetListener {
    private Border oldBorder;
    static private DataFlavor cdf = new DataFlavor(
       DataFlavor.javaJVMLocalObjectMimeType+";class="+Color.class.getName(),
       "Couleur java");
    public void dragEnter(DropTargetDragEvent e) {
	MonComposant current = ((MonComposant)e.getDropTargetContext().getComponent());
	oldBorder = current.getBorder();
	current.setBorder(new LineBorder(Color.GRAY,50));
    }
    public void dragExit(DropTargetEvent e) {
	MonComposant current = ((MonComposant)e.getDropTargetContext().getComponent());
	current.setBorder(oldBorder);
    }
    public void dragOver(DropTargetDragEvent e) {
    }
    public void drop(DropTargetDropEvent e) {
	MonComposant cp = (MonComposant)e.getDropTargetContext().getComponent();
	cp.setBorder(oldBorder);
	try {
	    Color c = (Color)e.getTransferable().getTransferData(cdf);
	    e.dropComplete(true);
	    cp.setBackground(c);
	    cp.repaint();
	} catch(UnsupportedFlavorException ue) {
	    ue.printStackTrace();
	} catch(IOException ie) {
	    ie.printStackTrace();
	}
    }
    public void dropActionChanged(DropTargetDragEvent e) {
    }
}

class MonComposant extends JPanel implements DragGestureListener, Autoscroll {
    private int cpt;
    static private ColorTransferHandler ct = new ColorTransferHandler();
    static private ColorDropTarget cdt = new ColorDropTarget();
    public MonComposant(Color c) {
	setBackground(c);
	setPreferredSize(new Dimension(400,400));
	this.setDropTarget(new DropTarget(this,cdt));
	//	DragSource ds = DragSource.getDefaultDragSource();
	DragSource ds = new DragSource();
	ds.createDefaultDragGestureRecognizer(this,DnDConstants.ACTION_COPY,this);
	}
    public void autoscroll(Point p) {
	// do the trick
      System.out.println("Autoscrolling "+new Date().getTime()+" Point="+p);
    }
    public Insets getAutoscrollInsets() {
	return getInsets();
    }
    public void dragGestureRecognized(DragGestureEvent e) {
	final BufferedImage bi = new BufferedImage(40,40,BufferedImage.TYPE_INT_RGB);
	final Graphics g = bi.getGraphics();
	g.setColor(e.getComponent().getBackground());
	g.fillRect(2,2,36,36);
	e.startDrag((Cursor)null,bi,new Point(-40,-40),new ColorTransfer(e.getComponent().getBackground()),null);
    }
}

public class DNDASExample implements Runnable {
    public void run() {
	MonComposant mc = new MonComposant(Color.BLUE);
	MonComposant mc2 = new MonComposant(Color.RED);
	MonComposant mc3 = new MonComposant(Color.GREEN);

	JFrame f = new JFrame("DND");
	f.getContentPane().setLayout(new FlowLayout());
	f.getContentPane().add(mc);
	f.getContentPane().add(mc2);
	f.getContentPane().add(mc3);
	JDialog d = new JDialog((JFrame)null);
	JColorChooser cc = new JColorChooser(mc.getBackground());
	cc.setDragEnabled(true);
	d.getContentPane().add(cc);

	f.pack();
	f.setVisible(true);
	d.pack();
	d.setVisible(true);
    }
    public static void main(String [] args) {
	SwingUtilities.invokeLater(new DNDASExample());
    }
}
