import java.awt.*;
import java.awt.dnd.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.text.*;
import java.awt.datatransfer.*;
import java.io.*;

class ColorTransferHandler extends TransferHandler {
    private DataFlavor cdf;
    private JPanel dropPanel;
  static int c = 0;

    public ColorTransferHandler(JPanel p) {
	cdf = new DataFlavor(DataFlavor.javaJVMLocalObjectMimeType+
			     ";class="+Color.class.getName(),"Couleur java");
	dropPanel = p;
    }
    public boolean canImport(TransferHandler.TransferSupport ts) {
	System.out.println("canImport "+c);
        c++;
	if (!ts.isDrop()) return false;
	System.out.println(cdf);
	return ts.isDataFlavorSupported(cdf);
    }
    public boolean importData(TransferHandler.TransferSupport ts) {
	System.out.println("importData");
	if (!canImport(ts)) return false;
	Transferable t = ts.getTransferable();
	try {
	    Color c = (Color)t.getTransferData(cdf);
            System.out.println(c);
	    dropPanel.setBackground(c);
	    return true;
	} catch(UnsupportedFlavorException ue) {
	    ue.printStackTrace();
	    return false;
	} catch(IOException ie) {
	    ie.printStackTrace();
	    return false;
	}
    }
}

public class DNDExample implements Runnable {
    public void run() {
	JPanel p = new JPanel();
	p.setPreferredSize(new Dimension(400,400));
	p.setTransferHandler(new ColorTransferHandler(p));
	p.setBackground(Color.BLUE);

	JFrame f = new JFrame("DND");
	f.getContentPane().setLayout(new FlowLayout());
	f.getContentPane().add(p);

	JDialog d = new JDialog((JFrame)null);
	JColorChooser cc = new JColorChooser(p.getBackground());
	cc.setDragEnabled(true);
	d.getContentPane().add(cc);

	f.pack();
	f.setVisible(true);
	d.pack();
	d.setVisible(true);
    }
    public static void main(String [] args) {
	SwingUtilities.invokeLater(new DNDExample());
    }
}
