import java.awt.*;
import java.awt.dnd.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.text.*;
import java.awt.datatransfer.*;
import java.io.*;
import java.util.List;
import java.util.Vector;

class Bidule implements Serializable {
    private Color c;
    public Bidule(Color c) { this.c = c; }
}

class ColorTransferable implements Transferable {
    public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException {
	if (isDataFlavorSupported(df)) {
	    List l = new Vector();
	    l.add(new File("."));
	    return l;
	}
	throw new UnsupportedFlavorException(df);
    }
    public DataFlavor[] getTransferDataFlavors() {
	DataFlavor [] dfs = new DataFlavor[1];
	dfs[0] = ColorTransferHandler.getFlavors()[2];
	System.out.println(dfs[0]);
	return dfs;
    }
    public boolean isDataFlavorSupported(DataFlavor f) {
	return f.equals(getTransferDataFlavors()[0]);
    }
}

class ColorTransferHandler extends TransferHandler {
    private static DataFlavor [] cdf;
    static {
	cdf = new DataFlavor[3];
	cdf[0] = new DataFlavor(DataFlavor.javaJVMLocalObjectMimeType+
				";class="+Color.class.getName(),"Couleur java");
	cdf[1] = DataFlavor.javaFileListFlavor;
	cdf[2] = DataFlavor.javaFileListFlavor;
	/*
	cdf[2] = new DataFlavor(Bidule.class,"Couleur java (externe)");
	/*
	cdf[2] = new DataFlavor(DataFlavor.javaSerializedObjectMimeType +
				";class="+Color.class.getName(),"Couleur java (externe)");
	*/
    }
    public ColorTransferHandler() {
	showFlavors(cdf);
    }
    public static DataFlavor[] getFlavors() {
	return cdf;
    }

    public int getSourceActions(JComponent c) {
	return TransferHandler.COPY;
    }
    public Transferable createTransferable(JComponent c) {
	return new ColorTransferable();
    }
    private void showFlavors(DataFlavor []dfs) {
	System.out.println("Supported Flavors");
	for (DataFlavor df : dfs) {
	    System.out.println("Flavor="+df);
	}
    }
    public boolean canImport(TransferHandler.TransferSupport ts) {
	System.out.println("canImport");
	showFlavors(ts.getDataFlavors());
	if (!ts.isDrop()) return false;
	for (DataFlavor df : cdf) {
	    if (ts.isDataFlavorSupported(df)) return true;
	}
	System.out.println("cannot import");
	return false;
    }
    public boolean importData(TransferHandler.TransferSupport ts) {
	System.out.println("importData");
	if (!canImport(ts)) return false;
	System.out.println("ok trying to get data");
	Transferable t = ts.getTransferable();
	try {
	    if (t.isDataFlavorSupported(cdf[0])) { 
		System.out.println("ok trying to get a color");
		Color c = (Color)t.getTransferData(cdf[0]);
		ts.getComponent().setBackground(c);
		return true;
	    }
	    if (t.isDataFlavorSupported(cdf[1])) { 
		System.out.println("ok trying to get a list");
		List l = (List)t.getTransferData(cdf[1]);
		System.out.println(l);
		return true;
	    }
	    if (t.isDataFlavorSupported(cdf[2])) { 
		System.out.println("ok trying to get a color (externe)");
		Color c = (Color)t.getTransferData(cdf[2]);
		ts.getComponent().setBackground(c);
		return true;
	    }
	    return false;
	} catch(UnsupportedFlavorException ue) {
	    ue.printStackTrace();
	    return false;
	} catch(IOException ie) {
	    ie.printStackTrace();
	    return false;
	}
    }
}

class MyPanel extends JPanel implements MouseListener {
    static private ColorTransferHandler ct = new ColorTransferHandler();
    public MyPanel(Color c) {
	setBackground(c);
	setPreferredSize(new Dimension(400,400));
	setTransferHandler(ct);
	this.addMouseListener(this);
    }
    public void mousePressed(MouseEvent e) {
	JPanel p = (JPanel)e.getSource();
	p.getTransferHandler().exportAsDrag(p,e,TransferHandler.COPY);
	e.consume();
    }
    public void mouseReleased(MouseEvent e) { }
    public void mouseClicked(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
}

public class DNDExterne implements Runnable {
    public void run() {
	JPanel p = new MyPanel(Color.BLUE);

	JFrame f = new JFrame("DND");
	f.getContentPane().setLayout(new FlowLayout());
	f.getContentPane().add(p);

	JDialog d = new JDialog((JFrame)null);
	JColorChooser cc = new JColorChooser(p.getBackground());
	cc.setDragEnabled(true);
	d.getContentPane().add(cc);

	f.pack();
	f.setVisible(true);
	d.pack();
	d.setVisible(true);
    }
    public static void main(String [] args) {
	SwingUtilities.invokeLater(new DNDExterne());
    }
}