import java.awt.*;
import java.awt.dnd.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.text.*;
import java.awt.datatransfer.*;
import java.io.*;
import javax.swing.border.*;

class ColorTransfer implements Transferable {
  private Color c;
  private DataFlavor []dfs;
  public ColorTransfer(Color c) {
    dfs = new DataFlavor[1];
    dfs[0] = new DataFlavor(DataFlavor.javaJVMLocalObjectMimeType+";class="+Color.class.getName(),"Couleur java");
    this.c = c;
  }
  public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException,IOException {
    if (!df.equals(dfs[0])) throw new UnsupportedFlavorException(df);
    return c;
  }
  public DataFlavor [] getTransferDataFlavors() {
    return dfs;
  }
  public boolean isDataFlavorSupported(DataFlavor df) {
    return df.equals(dfs[0]);
  }
}

class ColorTransferHandler extends TransferHandler {
  public int getSourceActions(JComponent c) {
    return TransferHandler.COPY;
  }
  protected Transferable createTransferable(JComponent c) {
    return new ColorTransfer(c.getBackground());
  }
}

class ColorDropTarget implements DropTargetListener {
  private Border oldBorder;
  static private DataFlavor cdf = new DataFlavor(DataFlavor.javaJVMLocalObjectMimeType+";class="+Color.class.getName(),"Couleur java");
  public void dragEnter(DropTargetDragEvent e) {
    System.out.println("dragEnter");
    MonComposant current = ((MonComposant)e.getDropTargetContext().getComponent());
    oldBorder = current.getBorder();
    current.setBorder(new LineBorder(Color.GRAY,50));
  }
  public void dragExit(DropTargetEvent e) {
    System.out.println("dragExit");
    MonComposant current = ((MonComposant)e.getDropTargetContext().getComponent());
    current.setBorder(oldBorder);
  }
  public void dragOver(DropTargetDragEvent e) {
    System.out.println("dragOver");
  }
  public void drop(DropTargetDropEvent e) {
    System.out.println("drop");
    MonComposant cp = (MonComposant)e.getDropTargetContext().getComponent();
    cp.setBorder(oldBorder);
    try {
      Color c = (Color)e.getTransferable().getTransferData(cdf);
      e.dropComplete(true);
      cp.setBackground(c);
    } catch(UnsupportedFlavorException ue) {
      ue.printStackTrace();
    } catch(IOException ie) {
      ie.printStackTrace();
    }
  }
  public void dropActionChanged(DropTargetDragEvent e) {
    System.out.println("dropActionChanged");
  }
}

class MonComposant extends JPanel{
  static private ColorTransferHandler ct = new ColorTransferHandler();
  static private ColorDropTarget cdt = new ColorDropTarget();
  public MonComposant(Color c) {
    setBackground(c);
    setPreferredSize(new Dimension(400,400));
    setTransferHandler(ct);
    this.setDropTarget(new DropTarget(this,cdt));
  }
}

public class DNDFinExample implements Runnable {
  public void run() {
    MonComposant mc = new MonComposant(Color.BLUE);
    MonComposant mc2 = new MonComposant(Color.RED);
    MonComposant mc3 = new MonComposant(Color.GREEN);

    JFrame f = new JFrame("DND");
    f.getContentPane().setLayout(new FlowLayout());
    f.getContentPane().add(mc);
    f.getContentPane().add(mc2);
    f.getContentPane().add(mc3);
    JDialog d = new JDialog((JFrame)null);
    JColorChooser cc = new JColorChooser(mc.getBackground());
    cc.setDragEnabled(true);
    d.getContentPane().add(cc);

    f.pack();
    f.setVisible(true);
    d.pack();
    d.setVisible(true);
  }
  public static void main(String [] args) {
    SwingUtilities.invokeLater(new DNDFinExample());
  }
}
