import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.print.*;
import java.awt.geom.*;
import java.awt.image.*;
import javax.print.*;
import javax.print.attribute.*;

class SpecialPanel extends JPanel implements MouseListener,MouseMotionListener,Printable {
    private int x, y, ox, oy;
    private Dimension dim;
    private BufferedImage bi;
    private Graphics gi;
    private AffineTransform scaling;
  int compteur;
    public SpecialPanel() {
	super();
	setBackground(Color.WHITE);
	dim = new Dimension(500,500);
	addMouseListener(this);
	scaling = new AffineTransform();
	scaling.scale(72.0f/300.0f,72.0f/300.0f); // 300 DPI scaling
        compteur = 0;
    }
    public void mousePressed(MouseEvent m) {
	ox = m.getX();
	oy = m.getY();
	addMouseMotionListener(this);
        System.out.println("On détecte les mouvements "+ox+","+oy);
    }
    public void mouseReleased(MouseEvent m) {
	removeMouseMotionListener(this);
        System.out.println("On ne détecte plus les mouvements");
    }
    public void mouseEntered(MouseEvent m) { }
    public void mouseExited(MouseEvent m) { }
    public void mouseClicked(MouseEvent m) { }
    public Dimension getPreferredSize() { return dim; }

    public int print(Graphics g,PageFormat f,int index) throws PrinterException {
      System.out.println("print("+index+")");
	if (index>3) return Printable.NO_SUCH_PAGE; // So, where is jimmy?
	((Graphics2D)g).translate(f.getImageableX(), f.getImageableY()); // offset jump
	((Graphics2D)g).drawImage(bi,scaling,null); // do the trick at 300 DPI
	return Printable.PAGE_EXISTS;
    }
    public void paintComponent(Graphics g) {
	if (bi==null) { // create on off-screen if needed
          System.out.println("Creation de l'image initiale");
	    bi = ((Graphics2D)g).getDeviceConfiguration().createCompatibleImage((int)dim.getWidth(),(int)dim.getHeight());
	    gi = bi.getGraphics();
	    gi.setColor(getBackground());
	    gi.fillRect(0,0,(int)dim.getWidth(),(int)dim.getHeight());
	    gi.setColor(Color.BLACK);
	}
        System.out.println("On dessine!");
	g.drawImage(bi,0,0,null); // do the trick at 72 DPI
    }

    public void mouseDragged(MouseEvent e) {
      System.out.println("Un mouvement! "+compteur++);
	x = e.getX(); // get a pos
	y = e.getY();
	gi.setColor(Color.BLACK);
	gi.drawLine(ox,oy,x,y); // draw it on off-screen image
	ox = x; // remember the pos
	oy = y;
	repaint(); // do the trick on screen
    }
    public void mouseMoved(MouseEvent e) { }
}

public class DrawingExample implements Runnable {
    public void run() {
	JFrame f = new JFrame("Drawing");
	final SpecialPanel l = new SpecialPanel();
	f.getContentPane().add(l);
	JMenu m = new JMenu("Fichier");
	JMenuItem mi1 = new JMenuItem("Imprimer");
	JMenuItem mi2 = new JMenuItem("Quitter");
	m.add(mi1);
	m.add(mi2);
	JMenuBar mb = new JMenuBar();
	mb.add(m);
	f.setJMenuBar(mb);
	f.pack();
	f.setVisible(true);

	mi1.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    PrinterJob pj = PrinterJob.getPrinterJob();
		    pj.setJobName("Un magnifique dessin");
		    pj.setPrintable(l);
		    if (pj.printDialog()) { // ask user
			try {
			    pj.print(); // do the trick
			} catch(PrinterException ex) {
			    ex.printStackTrace();
			}
	}
		}
	    });
	mi2.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    System.exit(0);
		}
	    });
    }
    public static void main(String []args) {
	SwingUtilities.invokeLater(new DrawingExample());
    }
}
