import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.io.*;
import javax.swing.filechooser.FileFilter;

class MonFiltre extends FileFilter {
    public boolean accept(File f) {
	char c = f.getName().charAt(0);
	return f.isDirectory() || c=='a' || c=='A';
    }
    public String getDescription() {
	return "Fichiers : [aA]*";
    }
}
class MonFiltre2 extends FileFilter {
    public boolean accept(File f) {
	char c = f.getName().charAt(0);
	return f.isDirectory() || c=='b' || c=='B';
    }
    public String getDescription() {
	return "Fichiers : [bB]*";
    }
}

class Auditeur implements ActionListener {
    private JFrame theFrame;
    public Auditeur(JFrame f) {
	theFrame = f;
    }
    public void actionPerformed(ActionEvent e) {
	JFileChooser fc = new JFileChooser();
	fc.setMultiSelectionEnabled(false);
	fc.setFileSelectionMode(JFileChooser.FILES_ONLY);
	fc.setFileFilter(new MonFiltre());
	fc.setFileFilter(new MonFiltre2());
	int résultat;
	if (e.getActionCommand().equals("Open"))
	    résultat = fc.showOpenDialog(theFrame);
	else
	    résultat = fc.showSaveDialog(theFrame);
	if (résultat == JFileChooser.APPROVE_OPTION) {
	    System.out.println(fc.getSelectedFile());
	}
    }
}

public class FileChooserExample implements Runnable {
    public void run() {
	JFrame fenetre = new JFrame("Fenêtre");
	JLabel l = new JLabel("Une superbe et magnifique fenêtre");
	l.setPreferredSize(new Dimension(400,200));
	fenetre.getContentPane().setLayout(new BorderLayout());
	fenetre.getContentPane().add(l,BorderLayout.CENTER);
	JMenuBar mb = new JMenuBar();
	JMenu menu = new JMenu("Fichier");
	JMenuItem mOpen = new JMenuItem("Ouvrir...");
	JMenuItem mSave = new JMenuItem("Sauver sous...");
	JMenuItem mQuit = new JMenuItem("Quitter");
	menu.add(mOpen);
	menu.add(mSave);
	menu.add(new JSeparator());
	menu.add(mQuit);
	mb.add(menu);
	fenetre.setJMenuBar(mb);
	mQuit.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    System.exit(0);
		}
	    });
	Auditeur a = new Auditeur(fenetre);
	mOpen.setActionCommand("Open");
	mSave.setActionCommand("Save");
	mOpen.addActionListener(a);
	mSave.addActionListener(a);

	fenetre.pack();
	fenetre.setVisible(true);
    }
    public static void main(String []args) {
	SwingUtilities.invokeLater(new FileChooserExample());
    }
}
