import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;

class MyFocusPolicy extends FocusTraversalPolicy {
    Vector<Component> components;
    public MyFocusPolicy(Vector<Component> c) {
	components = c;
    }
    public Component getComponentAfter(Container c,Component cp) {
	int index = components.indexOf(cp);
	index = index+2;
	if (index>=components.size())
	    if (index%2==0) index = 1;
	    else index=0;
	return components.get(index);
    }
    public Component getComponentBefore(Container c,Component cp) {
	int index = components.indexOf(cp);
	index = index-2;
	System.out.println("before  ="+index+" "+(index%2));
	if (index<0) {
	    if (index%2==0) {
		if (components.size()%2==0) index = components.size()-1;
		else index=components.size()-2;
	    } else {
		if (components.size()%2==0) index = components.size()-2;
		else index=components.size()-1;
	    }
	}
	return components.get(index);
    }
    public Component getDefaultComponent(Container c) {
	return components.get(5);
    }
    public Component getLastComponent(Container c) {
	return components.lastElement();
    }
    public Component getFirstComponent(Container c) {
	return components.get(0);
    }
}

public class FocusTraversal implements Runnable {
    public void run() {
	JFrame f = new JFrame("Focus traversal");
	Container c = f.getContentPane();
	c.setLayout(new GridLayout(3,4));

	Vector<Component> tfs = new Vector<Component>();
	for (int x=0; x<3; x++) {
	    for (int y=0; y<4; y++) {
		JTextField tf = new JTextField(10);
		tfs.add(tf);
		c.add(tf);
	    }
	}

	f.setFocusTraversalPolicy(new MyFocusPolicy(tfs));

	f.pack();
	f.setVisible(true);
    }
    public static void main(String []args) {
	SwingUtilities.invokeLater(new FocusTraversal());
    }
}
