import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

class FontListener implements ActionListener {
    private JLabel l;
    private JFrame c;
    public FontListener(JFrame c,JLabel l) { this.l = l; this.c = c; }
    public void actionPerformed(ActionEvent e) {
	l.setFont(new Font(((JMenuItem)e.getSource()).getText(),Font.PLAIN,24));
	c.pack();
    }
}

public class FontExample implements Runnable {
    public void run() {
	JFrame f = new JFrame("MonComposant");
	Container c = f.getContentPane();
	JMenu m = new JMenu("Polices");
	final JLabel l = new JLabel("Voix ambiguë d'un cœur qui, au zéphyr, préfère les jattes de kiwis.");
	c.add(l);
	String [] polices = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
	JMenu [] sm = new JMenu[27];
	for (char ch='A'; ch<='Z'; ch++) {
	    sm[ch-'A'] = new JMenu(""+ch);
	    m.add(sm[ch-'A']);
	}
	sm[26] = new JMenu("Autres");
	m.add(sm[26]);
	FontListener fl = new FontListener(f,l);
	for (String s: polices) {
	    JMenuItem mi = new JMenuItem(s);
	    mi.addActionListener(fl);
	    char ch = Character.toUpperCase(s.charAt(0));
	    if (ch>='A' && ch<='Z') sm[ch-'A'].add(mi);
	    else sm[26].add(mi);
	}
	JMenuBar mb = new JMenuBar();
	mb.add(m);
	f.setJMenuBar(mb);

	f.pack();
	f.setVisible(true);
    }
    public static void main(String []args) {
	SwingUtilities.invokeLater(new FontExample());
    }
}