import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import javax.swing.text.*;
import java.util.*;
import java.awt.image.*;
import java.net.*;
import javax.imageio.*;

class MyPanel extends JPanel {
  private Image image;
  public MyPanel() {
    try {
      URL url = new URI("https://yunes.informatique.univ-paris-diderot.fr/wp-content/uploads/fun/dip-1024x724.jpg").toURL();
      image = Toolkit.getDefaultToolkit().getImage(url); // asynchronous loading
      setPreferredSize(new Dimension(image.getWidth(null),image.getHeight(null)));
    } catch(Exception e) {
      e.printStackTrace();
    }
  }
  public void paintComponent(Graphics g) {
    g.drawImage(image,0,0,null);
  }
}

public class ImageAsyncLoadingExample implements Runnable {
  public static void main(String [] args) {
    SwingUtilities.invokeLater(new ImageAsyncLoadingExample());
  }
  public void run() {
    JFrame f = new JFrame(this.getClass().getName());
    Container c = f.getContentPane();
    MyPanel p = new MyPanel();
    c.add(p);
    f.pack();
    f.setVisible(true);
  }
}
