import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import javax.swing.text.*;
import java.util.*;
import java.awt.image.*;
import java.net.*;
import javax.imageio.*;

class MyPanel extends JPanel {
  private Image image;
  public MyPanel() {
    try {
      URL url = new URI("https://yunes.informatique.univ-paris-diderot.fr/wp-content/uploads/fun/dip-1024x724.jpg").toURL();
      image = ImageIO.read(url); // synchronous loading...
      setPreferredSize(new Dimension(image.getWidth(null)/2,image.getHeight(null)/2));
    } catch(Exception e) {
      e.printStackTrace();
    }
  }
  public void paintComponent(Graphics g) {
    g.drawImage(image,0,0,image.getWidth(null)/2,image.getHeight(null)/2,null);
  }
}

public class ImageIOExemple implements Runnable {
  public static void main(String [] args) {
    SwingUtilities.invokeLater(new ImageIOExemple());
  }
  public void run() {
    JFrame f = new JFrame(this.getClass().getName());
    Container c = f.getContentPane();
    MyPanel p = new MyPanel();
    c.add(p);
    f.pack();
    f.setVisible(true);
  }
}
