import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import javax.swing.text.*;
import java.util.*;
import java.awt.image.*;
import java.net.*;
import javax.imageio.*;

class MyPanel extends JPanel {
  private static final int N=5;
  private static final int M=10;
  private Image [][] images;
  private MediaTracker track;
  public MyPanel() {
    track = new MediaTracker(this);

    setPreferredSize(new Dimension(68*N,35*M));
    images = new Image[N][M];
    new Thread(new Runnable() {
        public void run() {
          for (int i=0; i<N; i++) {
            for (int j=0; j<M; j++) {
              try {
                String file = "https://yunes.informatique.univ-paris-diderot.fr/raw/images/zorglub"+i+"-"+j+".png";
                System.out.println("Loading "+file);
                URL url = new URI(file).toURL();
                images[i][j] = Toolkit.getDefaultToolkit().getImage(url).getScaledInstance(68,35,Image.SCALE_SMOOTH); // asynchronous loading
                track.addImage(images[i][j],i*N+j);
              } catch(Exception e) {
                e.printStackTrace();
              }
            }
          }
          System.out.println("Wait for loads");
          try {
            MyPanel.this.track.waitForAll();
          } catch(Exception e) {
            e.printStackTrace();
          }
          System.out.println("Loaded, painting now enforced");
          MyPanel.this.repaint();
        }
      }).start();
  }
  public void paintComponent(Graphics g) {
    System.out.println("paintComponent");
    for (int i=0; i<N; i++) {
      for (int j=0; j<M; j++) {
        System.out.println("Image: "+images[i][j]);
        if (images[i][j]!=null && track.checkID(i*N+j)) {
          g.drawImage(images[i][j],68*i,35*j,null);
        } else {
          g.drawString("on load",68*i,35*j+15);
        }
      }
    }
  }
}

public class ImageLoadingExample implements Runnable {
  public static void main(String [] args) {
    SwingUtilities.invokeLater(new ImageLoadingExample());
  }
  public void run() {
    JFrame f = new JFrame(this.getClass().getName());
    Container c = f.getContentPane();
    MyPanel p = new MyPanel();
    c.add(p);
    f.pack();
    f.setVisible(true);
  }
}
