import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import javax.swing.text.*;
import java.util.*;
import java.awt.image.*;
import java.net.*;
import javax.imageio.*;

class MyPanel extends JPanel {
  private BufferedImage image;
  public MyPanel() {
    try {
      URL url = new URI("https://yunes.informatique.univ-paris-diderot.fr/wp-content/uploads/fun/dip-1024x724.jpg").toURL();
      image = ImageIO.read(url); // synchronous loading...
      setPreferredSize(new Dimension(image.getWidth(null),image.getHeight(null)));
    } catch(Exception e) {
      e.printStackTrace();
    }
  }
  public void paintComponent(Graphics g) {
    float []f = {-1f,-1f,-1f,
                 -1f, 8f,-1f,
                 -1f,-1f,-1f};
    Graphics2D g2 = (Graphics2D)g;
    BufferedImageOp op = new ConvolveOp(new Kernel(3,3,f));
    g2.drawImage(image,op,0,0);
  }
}

public class ImageOpExemple implements Runnable {
  public static void main(String [] args) {
    SwingUtilities.invokeLater(new ImageOpExemple());
  }
  public void run() {
    JFrame f = new JFrame(this.getClass().getName());
    Container c = f.getContentPane();
    MyPanel p = new MyPanel();
    c.add(p);
    f.pack();
    f.setVisible(true);
  }
}
