import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import javax.swing.text.*;
import java.util.*;

public class JEditorPaneExample implements Runnable {
    public static void main(String [] a) {
	SwingUtilities.invokeLater(new JEditorPaneExample());
    }
    public void run() {
	JFrame f = new JFrame(this.getClass().getName());
	Container c = f.getContentPane();
	c.setLayout(new FlowLayout());
	try {
	    final JEditorPane e = new JEditorPane(new File("test.html").toURI().toURL());
	    e.addHyperlinkListener(new HyperlinkListener() {
		    public void hyperlinkUpdate(HyperlinkEvent ev) {
			if (ev.getEventType()==HyperlinkEvent.EventType.ACTIVATED)
			    try {
				e.setPage(ev.getURL());
			    } catch(IOException e) {
				e.printStackTrace();
			    }
		    }
		});
	    System.out.println(e.getDocument());
	    System.out.println(e.getContentType());
	    final JTextPane e2 = new JTextPane();
	    e2.setEditorKit(new StyledEditorKit());
	    e2.setDocument(e.getDocument());
	    System.out.println(e2.getDocument());
	    System.out.println(e2.getContentType());
	    c.add(e);
	    c.add(e2);
	    f.pack();
	    f.setVisible(true);
	} catch(IOException e) {
	    e.printStackTrace();
	}
    }
}