import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;
import java.util.*;
import javax.swing.event.*;

class Etudiant {
    private String nom;
    private int note1, note2;
    private boolean reçu;
    public Etudiant(String n,int n1,int n2) {
	nom = n; setNote1(n1); setNote2(n2); setReçu((note1+note2)/2>=10);
    }
    public void setNote1(int v) { note1 = v; setReçu((note1+note2)/2>=10); }
    public void setNote2(int v) { note2 = v;  setReçu((note1+note2)/2>=10); }
    public void setReçu(boolean b) { reçu = b; }
    public String getNom() { return nom; }
    public int getNote1() { return note1; }
    public int getNote2() { return note2; }
    public boolean getReçu() { return reçu; }
}

class MyTableModel extends AbstractTableModel {
    private Random r;
    private Etudiant []etudiants;
    public MyTableModel() {
	etudiants = new Etudiant[30];
	r = new Random();
	for (int i=0; i<getRowCount(); i++) {
	    etudiants[i] = new Etudiant("n°"+r.nextInt(100000),
					r.nextInt(21),
					r.nextInt(21));
	}
    }
    public String getColumnName(int colonne) {
	switch (colonne) {
	case 0: return "Nom";
	case 1: return "C++";
	case 2: return "Systèmes";
	case 3: return "Diplômé";
	}
	return "";
    }
    public int getColumnCount() {
	return 4;
    }
    public int getRowCount() {
	return etudiants.length;
    }
    public Object getValueAt(int ligne,int colonne) {
	Etudiant e = etudiants[ligne];
	switch (colonne) {
	case 0: return e.getNom();
	case 1: return e.getNote1();
	case 2: return e.getNote2();
	case 3: return e.getReçu();
	}
	return null;
    }
    public boolean isCellEditable(int ligne,int colonne) {
	return colonne>0;
    }
    public Class getColumnClass(int colonne) {
	return getValueAt(0,colonne).getClass();
    }    
    public void setValueAt(Object v, int ligne, int colonne) {
	Etudiant e = etudiants[ligne];
	switch (colonne) {
	case 0: break;
	case 1: e.setNote1((Integer)v); break;
	case 2: e.setNote2((Integer)v); break;
	case 3: e.setReçu((Boolean)v); break;
	}
	fireTableDataChanged();
    }
}

class MyTableRowSorter extends TableRowSorter<MyTableModel> {
    public MyTableRowSorter(MyTableModel m) {
	super(m);
    }
    public Comparator<?> getComparator(int c) {
	if (c==0) return new Comparator<String>() {
	    public int compare(String o1,String o2) {
		return o1.compareTo(o2);
	    }
	};
	if (c==3) return new Comparator<Boolean>() {
		public int compare(Boolean o1,Boolean o2) {
		    if (!o1.booleanValue()) return -1;
		    if (o1.equals(o2)) return 0;
		    return 1;
		}
	    };
	return new Comparator<Integer>() {
	    public int compare(Integer o1,Integer o2) {
		return o1.intValue()-o2.intValue();
	    }
	};
    }
}

class MyNomRenderer extends DefaultTableCellRenderer {
    private static Color backColor;
    static {
	backColor = new Color(210,255,210);
    }
    public Component getTableCellRendererComponent(JTable table,Object value,
						   boolean isSelected, 
						   boolean hasFocus,int ligne,
						   int colonne) {
	Component c = super.getTableCellRendererComponent(table,value,
						    isSelected,hasFocus,
						    ligne,colonne);
	c.setForeground(Color.black);
	c.setBackground(backColor);
	((JLabel)c).setHorizontalAlignment(SwingConstants.LEFT);
	return c;
    }
}

class MyNoteRenderer extends DefaultTableCellRenderer {
    private static Color backColor;
    static {
	backColor = new Color(210,210,255);
    }
    public Component getTableCellRendererComponent(JTable table,Object value,
						   boolean isSelected, 
						   boolean hasFocus,int ligne,
						   int colonne) {
	Component c = super.getTableCellRendererComponent(table,value,
						    isSelected,hasFocus,
						    ligne,colonne);
	c.setForeground(Color.red);
	c.setBackground(backColor);
        if (ligne%2==0) {
          ((JLabel)c).setHorizontalAlignment(SwingConstants.CENTER);
        }
        else {
          ((JLabel)c).setHorizontalAlignment(SwingConstants.LEFT);
        }
	return c;
    }
}

public class JTableExample implements Runnable {
    public void run() {
	JFrame f = new JFrame(getClass().getName());
	Container c = f.getContentPane();
	c.setLayout(new BorderLayout());

	final JTable t = new JTable();
	final MyTableModel tm = new MyTableModel();
	t.setModel(tm);
	final MyTableRowSorter trs = new MyTableRowSorter(tm);
	t.setRowSorter(trs);
	final RowFilter<MyTableModel,Object> rf = RowFilter.numberFilter(RowFilter.ComparisonType.AFTER,9,1);
	//	t.setAutoCreateRowSorter(true);
	
	TableColumn tc = t.getColumnModel().getColumn(1);
	tc.setCellRenderer(new MyNoteRenderer());

	tc = t.getColumnModel().getColumn(0);
	tc.setPreferredWidth(100);
	tc.setCellRenderer(new MyNomRenderer());
	/*
	MyIntegerCellRenderer r = new MyIntegerCellRenderer();
	t.setDefaultRenderer(Integer.class,r);
	*/

	t.setRowHeight(1,50);

	c.add(t,BorderLayout.CENTER);
	c.add(t.getTableHeader(),BorderLayout.NORTH);

	JMenuBar mb = new JMenuBar();
	JMenu fm = new JMenu("Filtrage");
	JToggleButton mi = new JRadioButton("Filtre");
	fm.add(mi);
	mb.add(fm);
	f.setJMenuBar(mb);
	mi.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    if (((JRadioButton)e.getSource()).isSelected())
			trs.setRowFilter(rf);
		    else
			trs.setRowFilter(null);
		}
	    });

	f.pack();
	f.setVisible(true);
    }
    public static void main(String [] args) {
	SwingUtilities.invokeLater(new JTableExample());
    }
}
