import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import javax.swing.tree.*;
import java.util.*;

class ARenderer extends JLabel {
    private static Color c = new Color(255,210,210);
    public ARenderer(String s) {
	super(s);
	setForeground(Color.blue);
	setBackground(c);
	setOpaque(true);
    }
}

class MyCellRenderer extends DefaultTreeCellRenderer {
    public Component getTreeCellRendererComponent(JTree tree,
						  Object value,
						  boolean sel,
						  boolean expanded,
						  boolean leaf,
						  int row,
						  boolean hasFocus) {
	if (leaf) {
	    return new ARenderer(value.toString());
	}
	return super.getTreeCellRendererComponent(tree,value,sel,expanded,leaf,row,hasFocus);
    }
}

class FileSystemNode implements TreeNode {
    private File current;
    private TreeNode parent;
    ArrayList<TreeNode> a;
    public FileSystemNode(String path,TreeNode parent) {
	current = new File(path);
	this.parent = parent;
    }
    private void fill() {
	if (a==null) {
	    a = new ArrayList<TreeNode>();
	    for (String s : current.list()) {
		if (s.charAt(0)=='.') continue;
		a.add(new FileSystemNode(current+"/"+s,this));
	    }
	}
    }
    public Enumeration<? extends TreeNode> children() {
	fill();
	return Collections.enumeration(a);
    }
    public boolean getAllowsChildren() {
	return current.isDirectory();
    }
    public TreeNode getChildAt(int n) {
	fill();
	return a.get(n);
    }
    public int getChildCount() {
	fill();
	return a.size();
    }
    public int getIndex(TreeNode c) {
	fill();
	return a.indexOf(c);
    }
    public TreeNode getParent() {
	return parent;
    }
    public boolean isLeaf() {
	return !current.isDirectory();
    }
    public String toString() {
	return current.getName().toString();
    }
}

public class JTreeExample implements Runnable {
    public static void main(String []args) {
	SwingUtilities.invokeLater(new JTreeExample());
    }
    public void run() {
	JFrame f = new JFrame(this.getClass().getName());
	Container c = f.getContentPane();
	JTree t = new JTree(new DefaultTreeModel(new FileSystemNode("/",null)));
	t.setCellRenderer(new MyCellRenderer());
	t.setRootVisible(false);
	t.addTreeSelectionListener(new TreeSelectionListener() {
		public void valueChanged(TreeSelectionEvent e) {
		    System.out.println("---");
		    System.out.println(e.getOldLeadSelectionPath());
		    System.out.println(e.getNewLeadSelectionPath());
		    System.out.println(e.getPath());
		}
	    });
	JScrollPane s = new JScrollPane(t);
	c.add(s);
	f.pack();
	f.setVisible(true);
    }
}
