import java.awt.*;
import javax.swing.*;

public class ListeExemple {
  static ImageIcon []images;
  static {
    images = new ImageIcon[4];
    images[0] = new ImageIcon("cagrignote.jpeg");
    images[1] = new ImageIcon("cagrimpe.jpeg");
    images[2] = new ImageIcon("capique.jpeg");
    images[3] = new ImageIcon("cajoue.jpeg");
  }
  static String []nombres = { "一 ichi", "二 ni", "三 san", "四 chi" };
  private static JPanel createJComboBoxPanel() {
    JPanel cbPanel = new JPanel();
    cbPanel.setName("ComboBoxes");
    JComboBox<String> cbs = new JComboBox<String>(nombres);
    cbPanel.add(cbs);
    cbs.setEditable(true);
    JComboBox<ImageIcon> cbi = new JComboBox<ImageIcon>(images);
    cbPanel.add(cbi);
    return cbPanel;
  }
  private static JPanel createJListPanel() {
    JPanel lPanel = new JPanel();
    lPanel.setName("Lists");
    JList<String> ls = new JList<String>(nombres);
    lPanel.add(ls);
    JList<ImageIcon> li = new JList<ImageIcon>(images);
    lPanel.add(li);
    
    return lPanel;
  }
  public ListeExemple() {
    JFrame fenetre = new JFrame(this.getClass().toString());
    
    JTabbedPane panneau = new JTabbedPane();
    panneau.add(createJComboBoxPanel());
    panneau.add(createJListPanel());

    fenetre.add(panneau);
    fenetre.pack();
    fenetre.setVisible(true);
  }
  public static void main(String []args) {
    SwingUtilities.invokeLater(new Runnable() {
        public void run() {
          new ListeExemple();
        }
      });
  }
}
