import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

class SpecialPanel extends JPanel implements MouseMotionListener {
    private String message;
    private int x, y;
    private Dimension dim;
    public SpecialPanel() {
	super();
	setBackground(Color.WHITE);
	dim = new Dimension(500,500);
	addMouseMotionListener(this);
    }
    public Dimension getPreferredSize() {
	return dim;
    }
    public void paintComponent(Graphics g) {
	super.paintComponent(g);
	if (message==null) return;
	g.setColor(Color.BLACK);
	g.drawString(message,x,y);
    }
    public void mouseDragged(MouseEvent e) {
	x = e.getX();
	y = e.getY();
	message = "dragged ("+x+','+y+')';
	repaint();
    }
    public void mouseMoved(MouseEvent e) {
	x = e.getX();
	y = e.getY();
	message = "moved ("+x+','+y+')';
	repaint();
    }
}

public class MouseMotionListenerBis implements Runnable {
    public void run() {
	JFrame f = new JFrame("MouseListenerExample");
	JPanel l = new SpecialPanel();
	f.getContentPane().add(l);
	f.pack();
	f.setVisible(true);
    }
    public static void main(String []args) {
	SwingUtilities.invokeLater(new MouseMotionListenerBis());
    }
}