import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

class DetecteurDeMouvement implements MouseMotionListener {
    public void mouseDragged(MouseEvent e) {
	System.out.println("dragged ("+e.getX()+','+e.getY()+')');
    }
    public void mouseMoved(MouseEvent e) {
	System.out.println("moved ("+e.getX()+','+e.getY()+')');
    }
}

class DetecteurDeClic implements MouseListener {
    private DetecteurDeMouvement dm;
    private boolean moveDetected;
    public DetecteurDeClic() {
	dm = new DetecteurDeMouvement();
	moveDetected = false;
    }
    public void mousePressed(MouseEvent e) {
	((Component)e.getSource()).addMouseMotionListener(dm);
	System.out.println("Ok, c'est parti!");
    }
    public void mouseReleased(MouseEvent e) {
	((Component)e.getSource()).removeMouseMotionListener(dm);
	System.out.println("Stop, y'en a marre!");
    }
    public void mouseClicked(MouseEvent e) {
	if (!moveDetected) {
	    ((Component)e.getSource()).addMouseMotionListener(dm);
	    System.out.println("On y va");
	}
	else {
	    ((Component)e.getSource()).removeMouseMotionListener(dm);
	    System.out.println("Basta");
	}
	moveDetected = !moveDetected;
    }
    public void mouseEntered(MouseEvent e) {
      System.out.println("Entered");
    }
    public void mouseExited(MouseEvent e) {
      System.out.println("Exited");
    }
}

public class MouseMotionListenerExample implements Runnable {
    public void run() {
	JFrame f = new JFrame("MouseListenerExample");
	JLabel l = new JLabel("Vas-y, joue avec la souris!");
	l.setPreferredSize(new Dimension(500,500));
	l.addMouseListener(new DetecteurDeClic());
	f.getContentPane().add(l);
	f.pack();
	f.setVisible(true);
    }
    public static void main(String []args) {
	SwingUtilities.invokeLater(new MouseMotionListenerExample());
    }
}
