import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

class SuiveurDeRoue implements MouseWheelListener {
    private JSlider s;
    public SuiveurDeRoue(JSlider s) { this.s = s; }
    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
	s.setValue(s.getValue()-e.getUnitsToScroll());
	System.out.println(e);
    }
}

public class MouseWheelListenerExample implements Runnable {
    public void run() {
	JFrame f = new JFrame("MouseListenerExample");
	JLabel l = new JLabel("Vas-y, bouge la roue!");
	l.setPreferredSize(new Dimension(500,500));
	JSlider s = new JSlider(SwingConstants.VERTICAL,0,200,100);
	s.addMouseWheelListener(new SuiveurDeRoue(s));
        JTextArea t = new JTextArea(20,20);
	t.addMouseWheelListener(new SuiveurDeRoue(s));
	f.getContentPane().setLayout(new BoxLayout(f.getContentPane(),BoxLayout.X_AXIS));
	f.getContentPane().add(l);
	f.getContentPane().add(s);
	f.getContentPane().add(t);
	f.pack();
	f.setVisible(true);
    }
    public static void main(String []args) {
	SwingUtilities.invokeLater(new MouseWheelListenerExample());
    }
}
