import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.plaf.*;
import javax.swing.plaf.synth.*;

public class PLAFSynth implements Runnable {
    public void run() {
	try {
	    SynthLookAndFeel look = new SynthLookAndFeel();
	    look.load(PLAFSynth.class.getResourceAsStream("MyLook.xml"),
		      PLAFSynth.class);
	    UIManager.setLookAndFeel(look);
	} catch(Exception ex) {
	    ex.printStackTrace();
	}

	JFrame f = new JFrame("PLAF test");
	JMenu m = new JMenu("Fichier");
	JMenuItem miOpen = new JMenuItem("Ouvrir...");
	JMenuItem miQuit = new JMenuItem("Quitter");
	m.add(miOpen);
	m.add(new JSeparator());
	m.add(miQuit);
	JMenuBar mb = new JMenuBar();
	mb.add(m);

	Container c = f.getContentPane();
	c.setLayout(new FlowLayout());
	JButton yo = new JButton("Yo!");
	JButton yo2 = new JButton("Yo2!");
	JButton yo3 = new JButton("Yo3!");
	yo2.setName("YO2");
	yo3.setName("YO3!");
	c.add(yo);
	c.add(yo2);
	c.add(yo3);
	c.add(new JLabel("Coucou"));

	yo.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    System.out.println("Yo Pushed");
		}
	    });
	yo2.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    System.out.println("Yo2 Pushed");
		}
	    });

	f.pack();
	f.setVisible(true);
    }
    public static void main(String [] args) {
	SwingUtilities.invokeLater(new PLAFSynth());
    }
}
