import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.plaf.*;
import javax.swing.plaf.metal.*;

class MyTheme extends DefaultMetalTheme {
    public String getName() {
	return "MyTheme";
    }
    protected ColorUIResource getPrimary1() {
	return new ColorUIResource(Color.GREEN);
    }
    protected ColorUIResource getPrimary2() {
	return new ColorUIResource(Color.RED);
    }
    protected ColorUIResource getPrimary3() {
	return new ColorUIResource(Color.BLUE);
    }
}

public class PLAFTheme implements Runnable {
    public void run() {
	try {
	    MetalLookAndFeel.setCurrentTheme(new MyTheme());
	    UIManager.setLookAndFeel(new MetalLookAndFeel());
	} catch(Exception ex) {
	    ex.printStackTrace();
	}

	JFrame f = new JFrame("PLAF test");
	JMenu m = new JMenu("Fichier");
	JMenuItem miOpen = new JMenuItem("Ouvrir...");
	JMenuItem miQuit = new JMenuItem("Quitter");
	m.add(miOpen);
	m.add(new JSeparator());
	m.add(miQuit);
	JMenuBar mb = new JMenuBar();
	mb.add(m);

	Container c = f.getContentPane();
	c.setLayout(new FlowLayout());
	c.add(new JButton("Yo!"));
	c.add(new JSlider());

	f.pack();
	f.setVisible(true);
    }
    public static void main(String [] args) {
	SwingUtilities.invokeLater(new PLAFTheme());
    }
}
