import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.plaf.*;
import javax.swing.plaf.metal.*;
import javax.swing.plaf.basic.*;

class ButtonMirrorUI extends MetalButtonUI {
    public void paint(Graphics g,JComponent c) {
	Graphics2D g2 = (Graphics2D)g.create();
	int largeur = c.getWidth();
	g2.scale(-1,1);
	g2.translate(-largeur,0);
	super.paint(g2,c);
    }
}

class ButtonListener implements ActionListener {
    public void actionPerformed(ActionEvent e) {
	JButton b = (JButton)e.getSource();
	if (b.getUI() instanceof ButtonMirrorUI) {
	    //	    ButtonUI bui = (ButtonUI)MetalButtonUI.createUI(b);
	    ButtonUI bui = new MetalButtonUI();
	    System.out.println(bui);
	    b.setUI(bui);
	} else {
	    b.setUI(new ButtonMirrorUI());
	}
    }
}

public class PLAFUI implements Runnable {
    public void run() {
	try {
	    UIManager.setLookAndFeel(new MetalLookAndFeel());
	} catch(Exception e) {
	    e.printStackTrace();
	}
	JFrame f = new JFrame("PLAF test");
	JMenu m = new JMenu("Fichier");
	JMenuItem miOpen = new JMenuItem("Ouvrir...");
	JMenuItem miQuit = new JMenuItem("Quitter");
	m.add(miOpen);
	m.add(new JSeparator());
	m.add(miQuit);
	JMenuBar mb = new JMenuBar();
	mb.add(m);

	Container c = f.getContentPane();
	c.setLayout(new FlowLayout());
	JButton yo = new JButton("Yo!");
	JButton yo2 = new JButton("Yo2!");
	JButton yo3 = new JButton("Yo3!");
	c.add(yo);
	c.add(yo2);
	c.add(yo3);
	c.add(new JLabel("Coucou"));

	ActionListener bl = new ButtonListener();
	yo.addActionListener(bl);
	yo2.addActionListener(bl);
	yo3.addActionListener(bl);

	f.pack();
	f.setVisible(true);
    }
    public static void main(String [] args) {
	SwingUtilities.invokeLater(new PLAFUI());
    }
}