import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import java.util.List;

// A class...
class Model {
    private int valeur;
    public Model(int v) { valeur = v; }
    public int getValeur() { return valeur; }
    public void setValeur(int v) {
	valeur = v;
    }
}

// An abstract view is something able to update itself from a model
interface View {
    public void update(Model m);
}

// A concrete view asks for model's state and changes accordingly
class View1 extends JLabel implements View { 
    public void update(Model m) {
	setText("Value="+m.getValeur());
    }
}

// Controler acts on model and tells views to update
class Controler implements ActionListener {
    private Model m;
    private List<View> vues;
    private void changeViews() {
	for (View v : vues) v.update(m);
    }

    public Controler(Model m ) {
	this.m = m;
	vues = new Vector<View>();
    }
    public void actionPerformed(ActionEvent e) {
	m.setValeur(m.getValeur()+1);
	changeViews();
    }    
    public void addView(View v) {
	if (vues.contains(v)) return;
	vues.add(v);
	v.update(m);
    }
}

public class PassiveMVC { //) implements Runnable {
  /*
    public void run() {
	Model m = new Model(0);
	JFrame f = new JFrame("MVC");
	View1 v1 = new View1();
	View1 v2 = new View1();
	View1 v3 = new View1();
	View1 v4 = new View1();
	View1 v5 = new View1();
	JButton b = new JButton("+1");
	Controler c = new Controler(m);
	c.addView(v1);
	c.addView(v2);
        c.addView(v3);
        c.addView(v4);
        c.addView(v5);
	b.addActionListener(c);

	f.getContentPane().setLayout(new FlowLayout());
	f.getContentPane().add(v1);
	f.getContentPane().add(v2);
	f.getContentPane().add(v3);
	f.getContentPane().add(v4);
	f.getContentPane().add(v5);
	f.getContentPane().add(b);
	f.pack();
	f.setVisible(true);
    }
  */
    public static void main(String []args) {
      //	SwingUtilities.invokeLater(new PassiveMVC());
	Model m = new Model(0);
	JFrame f = new JFrame("MVC");
	View1 v1 = new View1();
	View1 v2 = new View1();
	View1 v3 = new View1();
	View1 v4 = new View1();
	View1 v5 = new View1();
	JButton b = new JButton("+1");
	Controler c = new Controler(m);
	c.addView(v1);
	c.addView(v2);
        c.addView(v3);
        c.addView(v4);
        c.addView(v5);
	b.addActionListener(c);

	f.getContentPane().setLayout(new FlowLayout());
	f.getContentPane().add(v1);
	f.getContentPane().add(v2);
	f.getContentPane().add(v3);
	f.getContentPane().add(v4);
	f.getContentPane().add(v5);
	f.getContentPane().add(b);
	f.pack();
	f.setVisible(true);
    }
}
