import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.util.*;
import java.util.concurrent.*;
import java.util.List;

class LongJob extends SwingWorker<Integer,Integer> {
  private JProgressBar pb;
  private JLabel label;
  private int sum;
  public LongJob(JProgressBar pb, JLabel l) {
        this.pb = pb;
        this.label = l;
        this.sum = 0;
    }
  private final int N = 200;
    // This is the task to be done in background...
    public Integer doInBackground() {
      pb.setIndeterminate(false);
	Random r = new Random();
	for (int i=0; i<=N; i++) {
	    try {
              if (i<20 || i>40) {
		Thread.sleep(100+r.nextInt(500));
              }
              if (i==40) {
		Thread.sleep(5000);
              }
		// Feed the GUI !
		publish(i);
                // Advance computation of the final result
                sum += i;
                setProgress(100*i/N);
	    } catch(InterruptedException e) {
	    }
	}
	return sum;
    }

    // This is what has to be done under GUI's thread control...
    public void process(List<Integer> l) {
      this.label.setText(l.toString()+" : "+sum);
      this.pb.setValue(this.getProgress());
    }

    // RIP 'Lizard King', 7/3/71
    // This is the end, my only friend, the end, no safety or surprise, the end
    public void done() {
      //	pb.setVisible(false);
        try {
          this.label.setText("Sum is "+this.get());
        } catch(Exception e) {
          System.err.println("Oups");
        }
        //	firePropertyChange("done",false,true);
    }
}

class DoIt implements ActionListener {
    LongJob lj;
  public DoIt(JProgressBar pb, JLabel l) {
    lj = new LongJob(pb,l);
  }
    public void actionPerformed(ActionEvent e) {
	if (!lj.isDone()) {
	    lj.execute();
	}
    }
    public LongJob getJob() { return lj; }
}

public class ProgressBarExample implements Runnable {
    static private LongJob lj;
    public void run() {
	JFrame f = new JFrame("ProgressBarExample");
	Container c = f.getContentPane();
        JLabel result = new JLabel("...");
        c.add(result);
	c.setLayout(new BoxLayout(c,BoxLayout.Y_AXIS));
	JProgressBar pb = new JProgressBar(SwingConstants.HORIZONTAL,0,100);
	pb.setValue(0);
	pb.setStringPainted(true);
	pb.setIndeterminate(true);
	c.add(pb);
	JButton b = new JButton("Allez!");
	c.add(b);
	DoIt doit = new DoIt(pb,result);
	b.addActionListener(doit);
	JButton click = new JButton("Click!");
	c.add(click);
	click.addActionListener(e -> System.out.println("Click!"));
	f.pack();
	f.setVisible(true);

	lj = doit.getJob();
    }
    public static void main(String [] args) {
	try {
	    SwingUtilities.invokeAndWait(new ProgressBarExample());
	} catch (Exception e) {
	    e.printStackTrace();
	    System.exit(1);
	}
	try {
          System.out.println("Waitin in vain...");
	    // 'til can get enough...
	    lj.get();
          System.out.println("Ya!");

	} catch(Exception e) {
	}
	System.out.println("ici");
    }
}
