import java.awt.*;
import javax.swing.*;

public class ProgressMonitorExemple {
  public ProgressMonitorExemple() {
    final JFrame fenetre = new JFrame(this.getClass().toString());
    JLabel etiquette = new JLabel("<html><big>Yo!</big></html>");
    fenetre.getContentPane().add(etiquette);
    fenetre.pack();
    fenetre.setVisible(true);
    final ProgressMonitor moniteur = new ProgressMonitor(fenetre.getContentPane(),"Boulot","",0,100);
    moniteur.setMillisToDecideToPopup(5000);
    new Thread(new Runnable() {
        public void run() {
          try {
            for (int i=0; i<100 && !moniteur.isCanceled(); i++) {
              moniteur.setNote("Je bosse dur moi..."+i+"%");
              Thread.sleep(100);
              moniteur.setProgress(i);
            }
            moniteur.setNote("Terminé pour aujourd'hui");
            Thread.sleep(1000);
            moniteur.close();
          } catch(Exception e) {
          }
        }
      }).start();
  }
  public static void main(String []args) {
    SwingUtilities.invokeLater(new Runnable() {
        public void run() {
          new ProgressMonitorExemple();
        }
      });
  }
}
