import java.awt.*;
import javax.swing.*;
import java.text.*;
import java.util.*;

public class SliSpiExemple {
  static private class MyDataModel extends AbstractSpinnerModel {
    private static String s = "Jean-Baptiste Yunès";
    private int index;
    public MyDataModel() {
      index = 0;
    }
    public Object getNextValue() {
      if (index==s.length()-2) return null;
      index++;
      fireStateChanged();
      return getValue();
    }
    public Object getPreviousValue() {
      if (index==0) return null;
      index--;
      fireStateChanged();
      return getValue();
    }
    public Object getValue() {
      return ""+s.charAt(index)+s.charAt(index+1);
    }
    public void setValue(Object o) {
      //      fireStateChanged();
    }
  }
  public SliSpiExemple() {
    JFrame fenetre = new JFrame(this.getClass().toString());
    
    JPanel panneau = new JPanel();

    JSlider slider = new JSlider(0,100,50);
    panneau.add(slider);

    JSlider slider2 = new JSlider(0,100,50);
    slider2.setMajorTickSpacing(20);
    slider2.setMinorTickSpacing(10);
    slider2.setPaintTicks(true);
    slider2.setPaintLabels(true);
    slider2.setPaintTrack(false);
    slider2.setSnapToTicks(true);
    panneau.add(slider2);

    JSpinner spinner = new JSpinner(new SpinnerNumberModel(25,0,100,1));
    panneau.add(spinner);
    JSpinner spinner2 = new JSpinner(new MyDataModel());
    panneau.add(spinner2);

    fenetre.add(panneau);
    fenetre.pack();
    fenetre.setVisible(true);
  }
  public static void main(String []args) {
    SwingUtilities.invokeLater(new Runnable() {
        public void run() {
          new SliSpiExemple();
        }
      });
  }
}
