import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

class MButton extends JButton {
    public MButton(String s) { super(s); }
    public void paintComponent(Graphics g) {
	System.out.println("Button paintComponent");
	super.paintComponent(g);
    }
}

class P extends JPanel {
    public P() {
	setLayout(new FlowLayout());
	//setLayout(null);
	setPreferredSize(new Dimension(300,300));
    }
    public void paintComponent(Graphics g) {
	System.out.println("P paintComponent "+getBounds());
	super.paintComponent(g);
    }
    public void paintChildren(Graphics g) {
	System.out.println("P paintChildren");
	super.paintChildren(g);
    }
 }

class MM extends JPanel {
    public MM() {
	this.setBorder(new LineBorder(Color.BLACK,5));
	this.setLayout(new BorderLayout());
	MButton m = new MButton("coucou");
	m.setSize(new Dimension(80,30));
	this.add(m,BorderLayout.NORTH);
	MButton mm = new MButton("cuicui");
	this.add(mm,BorderLayout.CENTER);
	//System.out.println("bounds of bchild"+m.getBounds());
    }
    public void paintComponent(Graphics g) {
	System.out.println("MM paintComponent "+getBounds());
	super.paintComponent(g);
    }
    public void paintChildren(Graphics g) {
	System.out.println("MM paintChildren");
	for (int i=0; i<getComponentCount(); i++) {
	    Component c = getComponent(i);
	    System.out.println("Component("+i+")="+c.getBounds());
	}
	super.paintChildren(g);
    }
}

public class SplitPaneExample implements Runnable {
    public static int x;
    public static void main(String []a) {
	x=0;
	SwingUtilities.invokeLater(new SplitPaneExample());
    }
    public void run() {
	JFrame f = new JFrame("coucou");
	JSplitPane jsp = new JSplitPane();
	f.setContentPane(jsp);

	JPanel left = new JPanel();
	left.setLayout(new FlowLayout());
        //	left.setPreferredSize(new Dimension(300,300));
        left.setOpaque(true);
        left.setBackground(Color.BLUE);
	final JPanel right = new P();
        right.setOpaque(true);
        right.setBackground(Color.YELLOW);
	jsp.setLeftComponent(left);
	jsp.setRightComponent(right);
	right.add(new JButton("fsdhjkl"));

	JButton b = new JButton("add");
	left.add(b);
	b.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    MM m = new MM();
		    //m.setBounds((x%3)*100,(x/3)*60,100,60);x++;
		    right.add(m);
		    System.out.println("bounds of panel"+m.getBounds());
		    m.validate();
		    m.doLayout();
		    right.revalidate();
		    right.repaint();
		}
	    });
	f.pack();
	f.setVisible(true);
    }
}
