import javax.swing.event.*;

public class DefaultTickerModel implements TickerModel {
  protected EventListenerList listeners;
  private int secondes;
  private int delay;
  private Ticker ticker;
  public DefaultTickerModel(Ticker t) {
    listeners = new EventListenerList();
    delay = 1;
    secondes = 0;
    ticker = t;
  }
  public void addTickerListener(TickerListener tl) {
    listeners.add(TickerListener.class,tl);
  }
  public void removeTickerListener(TickerListener tl) {
    listeners.remove(TickerListener.class,tl);
  }
  public void fireTickerEvent() {
    TickerEvent e = new TickerEvent(this);
    Object []l = listeners.getListenerList();
    for (int i=l.length-1; i>=0; i-=2) {
      ((TickerListener)l[i]).tickPerformed(e);
    }
  }
  public  void setDelay(int s) {
    delay = s;
  }
  public  void start() {
    Thread t = new Thread(this);
    t.start();
  }
  public void run() {
    while (true) {
      secondes++;
      try {
        Thread.sleep(1000);
      } catch(Exception e) {
      }
      if (secondes%delay==0) fireTickerEvent();
      ticker.repaint();
    }
  }
}
