import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

class MonListener implements TickerListener {
  private JLabel label;
  private int count;
  public MonListener(JLabel l) {
    label = l;
    count = 0;
  }
  public void tickPerformed(TickerEvent te) {
    count++;
    label.setText(""+count);
  }
}

class MonAutreListener implements TickerListener {
  public void tickPerformed(TickerEvent te) {
    System.out.println("Tick");
  }
}

public class Main implements Runnable,ActionListener {
  private JFrame f;
  public void actionPerformed(ActionEvent e) {
    try {
      UIManager.setLookAndFeel(e.getActionCommand());
      SwingUtilities.updateComponentTreeUI(f);
    } catch(Exception ex) {
    }
  }
  public void run() {
    f = new JFrame("Essai");

    JMenu m = new JMenu("L&F");
    UIManager.LookAndFeelInfo[]infos = UIManager.getInstalledLookAndFeels();
    for (int i=0; i<infos.length; i++) {
      JMenuItem mi = new JMenuItem(infos[i].getName());
      mi.setActionCommand(infos[i].getClassName());
      mi.addActionListener(this);
      m.add(mi);
    }
    JMenuBar mb = new JMenuBar();
    f.setJMenuBar(mb);
    mb.add(m);

    Ticker t = new Ticker();
    JLabel l = new JLabel("--");
    TickerListener tl = new MonListener(l);
    t.addTickerListener(tl);
    TickerListener tl2 = new MonAutreListener();
    t.addTickerListener(tl2);
    Container c = f.getContentPane();
    c.setLayout(new BorderLayout());
    c.add(t,BorderLayout.CENTER);
    c.add(l,BorderLayout.SOUTH);
    f.pack();
    f.setVisible(true);
    t.setDelay(3);
    t.start();
  }
  public static void main(String []a) {
    SwingUtilities.invokeLater(new Thread(new Main()));
  }
}
