import javax.swing.*;
import javax.swing.plaf.*;
import java.lang.reflect.*;

public class Ticker extends JComponent {
  private TickerModel model;
  public Ticker() {
    TickerModel tm = new DefaultTickerModel(this);
    ComponentUI ui = new TickerUI();
    setUI(ui);
    model = tm;
  }
  public void addTickerListener(TickerListener tl) {
    model.addTickerListener(tl);
  }
  public void removeTickerListener(TickerListener tl) {
    model.removeTickerListener(tl);
  }
  public void setDelay(int secondes) {
    model.setDelay(secondes);
  }
  public void start() {
    model.start();
  }
  public void updateUI() {
    String n = UIManager.getLookAndFeel().getID();
    n = n+"TickerUI";
    Class<?> cl = null;
    try {
      cl = Class.forName(n);
    } catch(Exception e) {
      cl = TickerUI.class;
      System.out.println("No "+n+" available, defaulted to "+cl);
    }
    try {
      Method m = cl.getDeclaredMethod("createUI");
      Object o = m.invoke(cl);
      setUI((TickerUI)o);
      repaint();
    } catch(Exception e) {
      System.err.println("Problem while calling createUI for "+n);
    }
  }
}
