import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.undo.*;
import java.util.*;

class UndoableModification extends AbstractUndoableEdit {
    private int addedValue;
    private MyModel model;
    public UndoableModification(MyModel m,int v) {
	addedValue = v;
	model = m;
    }
    public String getPresentationName() {
	return ""+addedValue;
    }
    public boolean canRedo() {
	return true;
    }
    public boolean canUndo() {
	return true;
    }
    public void undo() {
	model.add(-addedValue);
    }
    public void redo() {
	model.add(addedValue);
    }
}

class MyLabel extends JLabel implements Observer {
    public MyLabel() {
	super("0",SwingConstants.RIGHT);
    }
    public void update(Observable o,Object v) {
	setText(v.toString());
        // setText(((MyModel)o).getValue());
    }
}

class MyModel extends Observable {
    private int value;
    public MyModel() {
	value = 0;
    }
    public void add(int v) {
	value += v;
	setChanged();
	notifyObservers(value);
    }
    public int getValue() {
	return value;
    }
}

class MyAction implements ActionListener {
    private MyModel m;
    private MyManager man;
    public MyAction(MyModel m,MyManager man) {
	this.m = m;
	this.man = man;
    }
    public void actionPerformed(ActionEvent e) {
	JTextField t = (JTextField)e.getSource();
	String s = t.getText();
	try {
	    int v = Integer.parseInt(s);
	    man.addEdit(new UndoableModification(m,v));
	    m.add(v);
	} catch(Exception ex) {
	    JOptionPane.showMessageDialog(t,"Ce n'est pas un entier");
	}
	t.setText("0");
    }
}

class MyManager extends UndoManager {
    private JMenuItem annuler, rétablir;
    public MyManager(JMenuItem a,JMenuItem r) {
	annuler = a;
	rétablir = r;
	annuler.setEnabled(false);
	rétablir.setEnabled(false);
	annuler.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    MyManager.this.undo();
		}
	    });
	rétablir.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    MyManager.this.redo();
		}
	    });
    }
    public boolean addEdit(UndoableEdit e) {
	boolean b = super.addEdit(e);
	updateItems();
	return b;
    }
    public void redo() {
	super.redo();
	updateItems();
    }
    public void undo() {
	super.undo();
	updateItems();
    }
    private void updateItems() {
	rétablir.setEnabled(canRedo());
	if (!canRedo()) {
	    rétablir.setText("Rétablir");
	} else {
	    rétablir.setText(editToBeRedone().getRedoPresentationName());
	}
	annuler.setEnabled(canUndo());
	if (!canUndo()) {
	    annuler.setText("Annuler");
	} else {
	    annuler.setText(editToBeUndone().getUndoPresentationName());
	}
    }
}

public class UndoRedo implements Runnable {
    public void run() {
	MyModel m = new MyModel();
	JFrame f = new JFrame("Undo—Redo");
	Container c = f.getContentPane();
	c.setLayout(new BorderLayout());
	MyLabel l = new MyLabel();
	m.addObserver(l);
	c.add(l,BorderLayout.NORTH);
	JTextField t = new JTextField(20);
	c.add(t,BorderLayout.SOUTH);

	JMenuBar mb = new JMenuBar();
	JMenu me = new JMenu("Édition");
	JMenuItem undo = new JMenuItem("Annuler");
	JMenuItem redo = new JMenuItem("Rétablir");
	me.add(undo);
	me.add(redo);
	mb.add(me);
	f.setJMenuBar(mb);

	MyManager man = new MyManager(undo,redo);
	t.addActionListener(new MyAction(m,man));

	f.pack();
	f.setVisible(true);
    }
    public static void main(String []args) {
	SwingUtilities.invokeLater(new UndoRedo());
    }
}
