package fr.jussieu.ufr_info_p7.T9;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 * The <code>T9</code> class implements a user interface for a completion
 * system. A default stupid completion system is provided by default.
 *
 * @author  Jean-Baptiste Yunès
 * @version 1.02, 2004-11-30
 * @see     Completion
 */
public class T9 {
    private class ToucheQuitter extends Button implements ActionListener {
	public ToucheQuitter(String symbole) {
	    super(symbole);
	    addActionListener(this);
	}
	public void actionPerformed(ActionEvent e) {
	    completion.termine();
	    System.exit(0);
	}
    }
    private class ToucheEfface extends Button implements ActionListener {
	public ToucheEfface(String symbole) {
	    super(symbole);
	    addActionListener(this);
	}
	public void actionPerformed(ActionEvent e) {
	    mots.clear();
	    completion.setMotCourant("");
	    rafraichit();
	}
    }
    private class ToucheCompletionOK extends Button implements ActionListener {
	public ToucheCompletionOK(String symbole) {
	    super(symbole);
	    addActionListener(this);
	}
	public void actionPerformed(ActionEvent e) {
	    completion.complete();
	    rafraichit();
	}
    }
    private class ToucheCompletionPrecedente extends Button implements ActionListener {
	public ToucheCompletionPrecedente(String symbole) {
	    super(symbole);
	    addActionListener(this);
	}
	public void actionPerformed(ActionEvent e) {
	    completion.completionPrecedente();
	    rafraichit();
	}
    }
    private class ToucheCompletionSuivante extends Button implements ActionListener {
	public ToucheCompletionSuivante(String symbole) {
	    super(symbole);
	    addActionListener(this);
	}
	public void actionPerformed(ActionEvent e) {
	    completion.completionSuivante();
	    rafraichit();
	}
    }
    private class ToucheArriere extends Button implements ActionListener {
	public ToucheArriere(String symbole) {
	    super(symbole);
	    addActionListener(this);
	}
	public void actionPerformed(ActionEvent e) {
	    if (completion.getMotCourant().length()>0) {
		completion.enleveDernierCaractere();
		rafraichit();
	    } else {
		if (!mots.empty()) {
		    completion.setMotCourant((String)mots.pop());
		    rafraichit();
		}
	    }
	}
    }
    private class ToucheEspace extends Button implements ActionListener {
	public ToucheEspace(String symbole) {
	    super(symbole);
	    addActionListener(this);
	}
	public void actionPerformed(ActionEvent e) {
	    if (completion.getMotCourant().length()==0) return;
	    mots.push(completion.getMotCourant());
	    completion.setMotCourant("");
	    rafraichit();
	}
    }
    private class Touche extends Button implements ActionListener {
	private char caractere;
	public Touche(char symbole) {
	    super(new Character(symbole).toString());
	    caractere = symbole;
	    addActionListener(this);
	}
	public char getChar() { return caractere; }
	public void actionPerformed(ActionEvent e) {
	    completion.ajouteCaractere(caractere);
	    rafraichit();
	}
    }
    private void rafraichit() {
	texte.setText(mots.toString()+
		      (mots.size()>0?" ":"")+
		      completion.getMotCourant());
	completionField.setText(completion.getCompletionCourante());
    }
    private static Completion completionParDefaut = new Completion() {
	    private StringBuffer prefixe = new StringBuffer();
	    private StringBuffer suffixe = new StringBuffer("A");
	    public void termine() { }
	    public void complete() {
		prefixe.append(suffixe);
		suffixe.setCharAt(0,'A');
	    }
	    public void setMotCourant(String mot) {
		if (mot==null) throw new NullPointerException();
		prefixe = new StringBuffer(mot);
		suffixe.setCharAt(0,'A');
	    }
	    public String getMotCourant() {
		return prefixe.toString();
	    }
	    public String getCompletionCourante() {
		return suffixe.toString();
	    }
	    public void completionPrecedente() {
		if (suffixe.charAt(0)>'A')
		    suffixe.setCharAt(0,(char)(suffixe.charAt(0)-1));
	    }
	    public void completionSuivante() {
		if (suffixe.charAt(0)<'Z')
		    suffixe.setCharAt(0,(char)(suffixe.charAt(0)+1));
	    }
	    public void ajouteCaractere(char c) {
		prefixe.append(c);
		suffixe.setCharAt(0,'A');
	    }
	    public void enleveDernierCaractere() {
		if (prefixe.length()>0) {
		    prefixe.setLength(prefixe.length()-1);
		}
	    }
	};
    private Stack mots = new Stack() {
	    public String toString() {
		StringBuffer s = new StringBuffer();
		Enumeration e = this.elements();
		if (e.hasMoreElements()) {
		    s.append(e.nextElement());
		}
		while (e.hasMoreElements())
		    s.append(" "+e.nextElement());
		return s.toString();
	    }
	};
    /**
     * Returns the default completion object. Its behaviour is very simple:
     * the sole possible completion is to add a new alphabetic upper-case
     * character.
     *
     * @return the default completion object
     */
    public static Completion getCompletionParDefaut() {
	return completionParDefaut;
    }
    private Completion completion;
    private TextField texte = new TextField("");
    private TextField completionField = new TextField("");
    /**
     * Constructs a T9 object with all necessary buttons.
     */
    public T9() {
	Frame fenetre = new Frame("T9");
	fenetre.setSize(300,300);
	fenetre.setLayout(new GridBagLayout());
	GridBagConstraints contraintes = new GridBagConstraints();
	contraintes.fill = GridBagConstraints.HORIZONTAL;
	contraintes.gridx = 0;
	contraintes.gridy = 0;
	contraintes.gridwidth = 10;
	texte.setEditable(false);
	fenetre.add(texte,contraintes);

	contraintes.gridy++;
	contraintes.gridwidth = 5;
	contraintes.gridx = 0;
	fenetre.add(new Label("Completion:"),contraintes);
	contraintes.gridx += contraintes.gridwidth;
	completionField.setEditable(false);
	fenetre.add(completionField,contraintes);

	contraintes.gridy++;
	contraintes.gridx = 8;
	contraintes.gridwidth = 2;
	fenetre.add(new ToucheEfface("Eff."),contraintes);

	contraintes.gridwidth = 1;
	contraintes.gridy++;
	contraintes.gridx = 0;
	for (char c='A'; c<='J'; c++) {
	    fenetre.add(new Touche(c),contraintes);
	    contraintes.gridx += contraintes.gridwidth;
	}
	contraintes.gridy++;
	contraintes.gridx = 0;
	for (char c='K'; c<='T'; c++) {
	    fenetre.add(new Touche(c),contraintes);
	    contraintes.gridx += contraintes.gridwidth;
	}
	contraintes.gridy++;
	contraintes.gridx = 0;
	for (char c='U'; c<='Z'; c++) {
	    fenetre.add(new Touche(c),contraintes);
	    contraintes.gridx += contraintes.gridwidth;
	}
	contraintes.gridwidth = 2;
	fenetre.add(new ToucheCompletionPrecedente("Préc."),contraintes);
	contraintes.gridx += contraintes.gridwidth;
	fenetre.add(new ToucheCompletionSuivante("Suiv."),contraintes);
	contraintes.gridx += contraintes.gridwidth;

	contraintes.gridy++;
	contraintes.gridx = 0;
	contraintes.gridwidth = 2;
	fenetre.add(new ToucheArriere("<--"),contraintes);
	contraintes.gridx += contraintes.gridwidth;
	contraintes.gridwidth = 6;
	fenetre.add(new ToucheEspace(""),contraintes);
	contraintes.gridx += contraintes.gridwidth;
	contraintes.gridwidth = 2;
	fenetre.add(new ToucheCompletionOK("Comp."),contraintes);
	contraintes.gridx += contraintes.gridwidth;

	contraintes.gridy++;
	contraintes.gridx = 8;
	contraintes.gridwidth = 2;
	fenetre.add(new ToucheQuitter("Quitter"),contraintes);

	fenetre.pack();
	fenetre.setVisible(true);
	completion = getCompletionParDefaut();
	rafraichit();
    }
    /**
     * Set the completion used by this T9 object.
     *
     * @param completion the completion to use.
     * @see   Completion
     */
    public void setCompletion(Completion completion) {
	if (completion==null) throw new NullPointerException();
	if (completion==this.completion) return;
	completion.setMotCourant(this.completion.getMotCourant());
	this.completion.termine();
	this.completion = completion;
	rafraichit();
    }
}
