package fr.upd.jby;
import java.awt.*;
import javax.swing.*;
import javax.swing.plaf.*;
import javax.accessibility.*;

/**
 * Source code <a href="AquaSpeedometerUI.java.html">here</a>.
 * @author Jean-Baptiste Yunès
 * @date 03/2011
 */
public class AquaSpeedometerUI extends BasicSpeedometerUI {
    private static SpeedometerUI speedometerUI;
    public static ComponentUI createUI(JComponent c) {
	System.out.println("AquaSpeedometerUI");
	if (speedometerUI==null) speedometerUI = new AquaSpeedometerUI();
	return speedometerUI;
    }
    public AquaSpeedometerUI() {
	arrowColor = new Color(200,120,120);
    }
    public void paint(Graphics og,JComponent co) {
	Graphics2D g = (Graphics2D)og;
	Speedometer c = (Speedometer)co;
	Color b = c.getBackground();
	Color f = c.getForeground();
	Dimension d = c.getSize();
	double w = d.getWidth();
	double h = d.getHeight();
	double r = 0;
	if (w>2*h) r = h;
	else r = w/2;
	g.setStroke(new BasicStroke(3));
	g.setColor(Color.WHITE);
	g.drawArc((int)(w/2-r),(int)(h-r),(int)(2*r),(int)(2*r),0,180);
	r -= 4;
	g.setStroke(new BasicStroke(3));
	g.setColor(Color.GRAY);
	g.drawArc((int)(w/2-r),(int)(h-r),(int)(2*r),(int)(2*r),0,180);
	g.setColor(Color.GRAY);
	g.fillArc((int)(w/2-10),(int)(h-10),(int)(2*10),(int)(2*10),0,180);
	int v = c.getValue();
	int m = c.getMinimum();
	int M = c.getMaximum();
	double fv = 1.0-(double)(v-m)/(double)(M-m);
	double a = fv*Math.PI;
	r -= 5;
	double x = r*Math.cos(a);
	double y = r*Math.sin(a);
	g.setStroke(new BasicStroke(5));
	g.setColor(arrowColor);
	g.drawLine((int)(w/2),(int)h,(int)(w/2+x),(int)(h-y));
	g.setColor(Color.BLACK);
	g.drawString(""+v,(int)(w/2)-20,(int)h-20);
	g.drawString("Aqua",10,20);
	g.drawString(""+c.getMinimum(),(int)(w/2-r+5),(int)(h-5));
	g.drawString(""+c.getMaximum(),(int)(w/2+r-5-20),(int)(h-5));
    }
}
