package fr.yunes.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileScanner {
	private File file;
	public FileScanner(File file) {
		this.file = file;
	}
	public long count(String word, boolean debug) {
		if (debug) {
			System.out.print("+");
			System.out.flush();
		}
		long count = countHandler(word);
		if (debug) {
			System.out.print("-");
			System.out.flush();
		}
		return count;
	}
	private long countHandler(String word) {
		try (var reader = new BufferedReader(new FileReader(file))) {
			long count = 0;
			Pattern p = Pattern.compile("\\b"+word+"\\b");
				count = reader.lines()
						.map(p::matcher)
						.flatMap(Matcher::results)
						.map(MatchResult::group)
						.mapToLong(s -> 1L)
						.sum();
			return count;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return 0L;
	}
}