package fr.yunes.file;

import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;

public final class Utils {
	private Utils() {}
	public static String WORD = "homme";
	public static long measure(String msg, Runnable r) {
		System.out.println("\n-----------------------------------------"+msg);
		long start = System.currentTimeMillis();
		r.run();
		long end = System.currentTimeMillis();
		long duration = end-start;
		System.out.println("Time="+duration+"ms");
		return duration;
	}
	public static List<Path> init(String pathname) {
		final Path DIRECTORY = Path.of(pathname);
		try (DirectoryStream<Path> ds = Files.newDirectoryStream(DIRECTORY,"pg*.txt")) {
			List<Path> l = StreamSupport.stream(ds.spliterator(), false).toList();
			l.forEach(System.out::println);
			
//			// Example
//			FileScanner f = new FileScanner(l.get(0).toFile());
//			System.out.println(f.count(WORD,true));
			
			return IntStream.range(0, 200)
					.mapToObj(i -> l)
					.flatMap(List::stream)
					.toList();
		} catch (Exception e) {
			return List.of();
		}
	}
}
