package fr.yunes.test;

import java.time.Month;
import java.time.YearMonth;
import static java.util.Comparator.*;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

import static java.util.stream.Collectors.*;

import java.io.File;

import fr.yunes.tp2.Data;
import fr.yunes.tp2.Identity;
import fr.yunes.tp2.Person;
import fr.yunes.tp2.Position;
import fr.yunes.tp2.Salary;
import fr.yunes.tp2.Verifiers;


public class MainTemplate {
	record IdSalary(Identity id, Salary s) {
		@Override
		public String toString() {
			return id+":"+s;
		}
	}

	record IdValue(Identity id,int value) {
		@Override
		public String toString() {
			return id+": "+value+"$";
		}
	};

	record IdRate(Identity id, int rate) {
		@Override
		public String toString() {
			return id+": "+rate+"%";
		}
	}

	public static List<Character> question2(Stream<Person> s) {
		return null;
	}
	public static List<String> question3(Stream<Person> s) {
		return null;
	}
	public static List<Identity> question4(Stream<Person> s) {
		return null;
		}
	public static List<Identity> question5(Stream<Person> s) {
		return null;
	}
	public static Map<Position,Long> question6(Stream<Person> s) {
		return null;
	}
	public static Map<Integer,? extends Set<Identity>> question7(Stream<Person> s) {
		return null;
	}
	public static List<IdSalary> question8(Stream<Person> s) {
		return null;
	}
	public static List<Salary> question9(Stream<Person> s) {
		return null;
	}
	public static int question10(Stream<Person> s) {
		return 0;
	}
	public static List<IdValue> question11(Stream<Person> s) {
		return null;
	}
	public static List<IdValue> question12(Stream<Person> s) {
		return null;
	}
	public static List<IdRate> question13(Stream<Person> s) {
		return null;
	}
	
	public static String question13bis(Stream<IdRate> s) {
		return null;
	}
	public static Map<Integer,? extends Set<Identity>> question14(Stream<Person> s) {
		return null;
	}
	
	public static Map<Integer,? extends Map<Character, ? extends Set<Identity>>> question15(Stream<Person> s) {
		return null;
	}

	public static void main(String[] args) {
		//BEGIN lecture du fichier person.ser
		Collection<Person> l = List.of();
		File f = new File("person.ser");
		if (!f.exists())  {
			l = Person.create();
			try (var fc = new FileConsumer(f)) {
				System.out.println("Saving list");
				l.forEach(fc);
				System.out.println("List saved");
			} catch (Exception e) {
				f.delete();
			}
		}
		try (var fs = new FileSupplier(f)) {
			System.out.println("Reading list");
			l = Stream.generate(fs).takeWhile(Objects::nonNull).toList();
			System.out.println("List read");
		} catch (Throwable e) {
			e.printStackTrace();
			System.exit(1);
		}
		System.out.println(l.size());
		//END lecture
		
			
		// Question 2
		System.out.println("\n---------------------All first letters of last names");
		var letters = question2(l.stream());
		
		// Test question 2
		Verifiers.printAndVerify(letters.stream(), Data.ALL_LETTERS, false);
		
		// Question 3
		System.out.println("\n---------------------Last name of employees that begins with S");
		var lnbs = question3(l.stream());
		
		// Test question 3
		Verifiers.printAndVerify(lnbs.stream(), Data.NAMES_S, false);

		// Question 4
		System.out.println("\n---------------------Employee by lastname then firstname");
		var eLF = question4(l.stream());
		
		// Test question 4
		Verifiers.printAndVerify(eLF.stream(), Data.NAMES_FIRST_LAST, false);
		
		// Question 5
		System.out.println("\n---------------------Managers");
		var managers = question5(l.stream());
		
		// Test question 5
		Verifiers.printAndVerify(managers.stream(), Data.MANAGERS, false);

		// Question 6
		System.out.println("\n---------------------Count by position");
		var byPos = question6(l.stream());
		
		// test question 6
		var byPosTest = byPos.entrySet().stream()
				.map(e->e.getKey()+": "+e.getValue())
				.collect(joining(", "));
		System.out.println(byPosTest);
		assert Data.COUNT_BY_POSITION.equals(byPosTest) : "bad";

		// Question 7
		System.out.println("\n---------------------Employee by birthYear");
		var bySortedBirthYear = question7(l.stream());
	
		// Test question 7
		Verifiers.printAndVerify(bySortedBirthYear, i -> "Year "+i+": ", Data.BY_BIRTH_YEAR);
		
		// Question 8
		System.out.println("\n---------------------Well paid managers (≥4000$)");
		var wellPaid = question8(l.stream());
		
		// Test question 8
		Verifiers.printAndVerify(wellPaid.stream(), Data.WELL_PAID, false);
		
		// Question 9
		System.out.println("\n---------------------All well paiments by date (≥4000$)");
		var allWell = question9(l.stream());
		
		// Test question 9
		Verifiers.printAndVerify(allWell.stream(), Data.ALL_WELL, true);

		// Question 10
		System.out.println("\n---------------------Sum of salaries in January 2022");
		var sumJan2022 = question10(l.stream());
		
		// Test question 10
		System.out.println("Total in Jan 2022 "+sumJan2022+"$");
		assert sumJan2022==2780156 : "oups";
		
		// Question 11
		System.out.println("\n---------------------Total salaries for each employee");
		var totalByEmployee = question11(l.stream());
		
		// Test question 11;
		Verifiers.printAndVerify(totalByEmployee.stream(), Data.TOTAL_BY_EMPLOYEE, true);
		
		// Question 12
		System.out.println("\n---------------------Mean salary for each employee");
		var meanByEmployee = question12(l.stream());
		
		Verifiers.printAndVerify(meanByEmployee.stream(), Data.MEAN_BY_EMPLOYEE, true);

		// Question 13
		System.out.println("\n---------------------% of salary increase for each employee");
		var rates = question13(l.stream());
		
		// Test question 13
		Verifiers.printAndVerify(rates.stream(),Data.INCREASE,true);
		
		String msg = question13bis(rates.stream());
		System.out.println("Best inscrease, "+msg);
		assert msg.equals("Ben Huerta: 416%"): "oups";
		
		//  Question 14
		System.out.println("\n---------------------Employees by range of salary");
		var byRange = question14(l.stream());
		
		// Test question 14
		Verifiers.printAndVerify(byRange, i -> i+"--"+(i+499)+": ", Data.BY_RANGE);		

		// Question 15
		System.out.println("\n---------------------Employees by first letter by range of salary");
		var byFR = question15(l.stream());
		
		// Test question 15
		for (var e: byFR.entrySet()) {
			System.out.println(e.getKey());
			for (var e2: e.getValue().entrySet()) {
				System.out.print("\t"+e2.getKey()+": ");
				String s = e2.getValue().stream().map(Object::toString).collect(joining(", "));
				if (s.length()>150) {
					s = s.substring(0,150)+"...";
				}
				System.out.println(s);
			}
		}
	}
}
