package fr.yunes.tp2;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;

public class Person implements Serializable {
	private Identity id;
	private Position position;
	private LocalDate birthDay;
	private List<Salary> salaries;
	
	public Person(String lastName, String firstName,
			Position position, LocalDate birthDay) {
		Objects.requireNonNull(lastName);
		Objects.requireNonNull(firstName);
		Objects.requireNonNull(position);
		Objects.requireNonNull(birthDay);
		this.id = new Identity(firstName.strip(),lastName.strip());
		this.position = position;
		this.birthDay = birthDay;
		salaries = new ArrayList<>();
	}
	public void addSalary(Salary s) {
		salaries.add(s);
	}
	private static DateTimeFormatter formatter = DateTimeFormatter.ofPattern("d MMMM y",Locale.ENGLISH);
	public String toString() {
		return id
				+" ("+birthDay.format(formatter)+")"
				+", "+position
				+", "+salaries;
	}
	public String getLastName() {
		return id.lastName();
	}
	public String getFirstName() {
		return id.firstName();
	}
	public Identity getId() {
		return id;
	}
	public Position getPosition() {
		return position;
	}
	public LocalDate getBirthDay() {
		return birthDay;
	}
	public Collection<Salary> getSalaries() {
		return salaries;
	}
	public Salary getFirstSalary() {
		return salaries.getFirst();
	}
	public Salary getLastSalary() {
		return salaries.getLast();
	}
	
	private static Random r = new Random(1);
	private static final int MIN_YEAR = 1980;
	private static final int MAX_YEAR = 1990;
	private static LocalDate randomDay(int minYear, int maxYear) {
		Year y = Year.of(r.nextInt(minYear, maxYear));
		int dayOfYear = r.nextInt(1,y.length()+1);
		return LocalDate.ofYearDay(y.getValue(), dayOfYear);		
	}
	private static LocalDate randomBirthDay() {
		return randomDay(MIN_YEAR, MAX_YEAR);
	}
	private static Collection<Salary> randomSalaries(Person p) {
		Collection<Salary> s = new ArrayList<>();
		
		LocalDate start = randomDay(p.getBirthDay().getYear()+20,2010);
		YearMonth startYM = YearMonth.of(start.getYear(), start.getMonth());
		
		YearMonth toDay = YearMonth.now();

		long months = ChronoUnit.MONTHS.between(startYM, toDay);
		
		YearMonth endYM = startYM.plusMonths(r.nextLong(Long.max(months-12,1), months+1));
		YearMonth currentYM = startYM;
		int salary = r.nextInt(Salary.MIN_SALARY, (int)(Salary.MIN_SALARY*1.5));
		while (currentYM.isBefore(endYM)) {
			s.add(new Salary(currentYM, salary));
			currentYM = currentYM.plusMonths(1);
			if (r.nextInt(24)==0) {
				salary += r.nextInt(100,300);
				if (salary>Salary.MAX_SALARY) {
					salary = Salary.MAX_SALARY;
				}
			}
		}
		return s;
	}
	public static Collection<Person> create() {
		Collection<Person> l = new ArrayList<>();
		for (var d: Data.names) {
			Person p = new Person(d[0], d[1], Position.random(), randomBirthDay());
			randomSalaries(p).forEach(p::addSalary);
			l.add(p);
		}
		return l;
	}

}
