package fr.yunes.tp2;

import java.io.Serializable;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Objects;

public record Salary(YearMonth date, int value) implements Serializable {
	public static final int MIN_SALARY = 1000;
	public static final int MAX_SALARY = 5000;
	public static DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MMMM y", Locale.ENGLISH);
	public Salary {
		if (value<MIN_SALARY) {
			throw new IllegalArgumentException("Salary "+value+" less than "+MIN_SALARY);
		}
		Objects.requireNonNull(date);
	}
	@Override
	public String toString() {
		return date.format(formatter)
				+ " ==> " + value + "$";
	}
}
