package fr.yunes.tp2;

import static java.util.stream.Collectors.joining;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;

public final class Verifiers {
	private Verifiers() {};
	
	public static <T> void printAndVerify(Stream<T> s, String good, boolean cut) {
		var result = s.map(Object::toString).collect(joining(", "));
		if (cut) {
			result = result.substring(0,150)+"...";
			good = result.substring(0,150)+"...";
		}
		System.out.println(result);
		assert result.equals(good) : "oups";
	}
	
	public static <V> void printAndVerify(Map<Integer,? extends Collection<V>> m, Function<Integer,String> writer, String good) {
		StringBuilder b = new StringBuilder();
		for (var e: m.entrySet()) {
			b.append(writer.apply(e.getKey()));
			String s = e.getValue().stream().map(Object::toString).collect(joining(", ","","\n"));
			if (s.length()>=150) {
				s = s.substring(0,150)+"...\n";
			}
			b.append(s);
		}
		System.out.println(b);
		assert good.equals(b.toString()) : "oups";
	}
}
